/*
Run this script on:

        DNS          .aac.dva.DNS   .CRS    -  This database will be modified

to synchronize it with:

        DNS          .aac.dva.DNS   .CRS

You are recommended to back up your database before running this script

Script created by SQL Compare version 11.1.3 from Red Gate Software Ltd at 3/28/2018 6:41:52 PM

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO
BEGIN TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_NATIONALDRUG]'
GO
IF OBJECT_ID(N'[CRS].[STD_NATIONALDRUG]', 'U') IS NULL
CREATE TABLE [CRS].[STD_NATIONALDRUG]
(
[NationalDrugSID] [int] NULL,
[NationalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[DrugNameWithoutDoseSID] [int] NULL,
[NationalFormularyFlag] [varchar] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalFormularyName] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VADrugPrintName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAProductIdentifier] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CMOPTransmitFlag] [varchar] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CSFederalSchedule] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ProductSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GCNSeqNo] [int] NULL,
[PreviousGCNSeqNo] [int] NULL,
[NDCToGCNSeqNo] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Strength] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StrengthNumeric] [decimal] (18, 0) NULL,
[DosageFormSID] [int] NULL,
[DispenseUnitSID] [int] NULL,
[DrugUnitSID] [int] NULL,
[PrimaryDrugClassSID] [int] NULL,
[DSSNumber] [int] NULL,
[InactivationDate] [date] NULL,
[InactivationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactivationDateTransformSID] [bigint] NULL,
[ExcludeFromDrugInteractionCheckFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[OverrideDoseCheckExclusionFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CreateDefaultPossibleDosageFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PossibleDosagesToCreateIndicator] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FDAMedGuide] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ChargemasterServiceCode] [int] NULL,
[OutpatientOrInpatientPackageUse] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxSingleDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MinSingleDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxDailyDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MinDailyDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxCumulativeDose] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MasterEntryForVUIDFlag] [varchar] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VUID] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DispenseUnitIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DosageFormIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugNameWithoutDoseIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugUnitIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PrimaryDrugClassIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-SID] on [CRS].[STD_NATIONALDRUG]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-SID' AND object_id = OBJECT_ID(N'[CRS].[STD_NATIONALDRUG]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-SID] ON [CRS].[STD_NATIONALDRUG] ([NationalDrugSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID-ETLID] on [CRS].[STD_NATIONALDRUG]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID-ETLID' AND object_id = OBJECT_ID(N'[CRS].[STD_NATIONALDRUG]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-SID-ETLID] ON [CRS].[STD_NATIONALDRUG] ([NationalDrugSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_DRUGNAMEWITHOUTDOSE]'
GO
IF OBJECT_ID(N'[CRS].[STD_DRUGNAMEWITHOUTDOSE]', 'U') IS NULL
CREATE TABLE [CRS].[STD_DRUGNAMEWITHOUTDOSE]
(
[DrugNameWithoutDoseSID] [int] NULL,
[DrugNameWithoutDoseIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[DrugNameWithoutDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactivationDate] [date] NULL,
[VUID] [int] NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndx-SID] on [CRS].[STD_DRUGNAMEWITHOUTDOSE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndx-SID' AND object_id = OBJECT_ID(N'[CRS].[STD_DRUGNAMEWITHOUTDOSE]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndx-SID] ON [CRS].[STD_DRUGNAMEWITHOUTDOSE] ([DrugNameWithoutDoseSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndx-SID-ETLID] on [CRS].[STD_DRUGNAMEWITHOUTDOSE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndx-SID-ETLID' AND object_id = OBJECT_ID(N'[CRS].[STD_DRUGNAMEWITHOUTDOSE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndx-SID-ETLID] ON [CRS].[STD_DRUGNAMEWITHOUTDOSE] ([DrugNameWithoutDoseSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[vw_TransplantRegistryMedications]'
GO
IF OBJECT_ID(N'[CRS].[vw_TransplantRegistryMedications]', 'V') IS NULL
EXEC sp_executesql N'/*RTC#666418
Date 3/12/2018 wal
*/
CREATE VIEW [CRS].[vw_TransplantRegistryMedications] AS
SELECT
   a.RxOutpatSID 
  ,a.RxNumber
  ,a.IssueDate
  ,a.RxStatus
  ,a.CancelDate
  ,a.FinishingDateTime
  ,a.PatientSID
  ,a.ProviderSID
  ,a.PatientStatus
  ,a.MaxRefills
  ,a.LastDispensedDate
  ,a.NextPossibleFillDate
  ,a.PriorFillDate
  ,a.HoldDate
  ,a.TradeLabelName
  ,a.OrderedQuantity
  ,a.OrderedQuantityNumeric
  FROM [CRS].[RXOUTPAT] AS a
  INNER JOIN crs.Std_NationalDrug AS b 
        ON b.NationalDrugSID = a.NationalDrugSID
  INNER JOIN crs.STD_DRUGNAMEWITHOUTDOSE AS c ON c.DrugNameWithoutDoseSID = b.DrugNameWithoutDoseSID
  WHERE b.NationalDrugSID <> -1 AND a.RxNumber <> ''*Unknown at this time*''
  AND a.RxStatus IN (''ACTIVE'',''HOLD'',''SUSPENDED'')
  AND CONVERT(DATE,a.IssueDate) <= CONVERT(DATE,GETDATE()-30)
  AND c.DrugNameWithoutDose IN (''Azathioprine'', ''Cyclosporine'', ''Everolimus'', ''Mycophenolate'', ''Sirolimus'', ''Prednisone'',''Tacrolimus'')
'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[usp_Patient_Individual_Add]'
GO
IF OBJECT_ID(N'[CRS].[usp_Patient_Individual_Add]', 'P') IS NULL
EXEC sp_executesql N'-- =============================================
-- Author: Whitney Lawson       
-- Create date:   11/28/2017
-- Description:   Add an individual to a Registry Cohort
-- =============================================
Create PROCEDURE [CRS].[usp_Patient_Individual_Add] 
(@Update_USER VARCHAR(30), @CURRENT_REGISTRY_ID INT, @PATIENT_ICN VARCHAR(50))
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @CohortTypeId INT
SET @CohortTypeId =(SELECT DISTINCT COHORT_TYPE_ID
                    FROM [CRS].[CRS].[STD_REGISTRY_COHORT_TYPES]
                    WHERE DESCRIPTION_TEXT = ''PatientICN'')

UPDATE [CRS].[CRS].[STD_REGISTRY_COHORT_TYPES]
SET NAME = @PATIENT_ICN
   ,CODE = @PATIENT_ICN
WHERE COHORT_TYPE_ID = @CohortTypeId;

INSERT INTO [CRS].[REGISTRY_COHORT_DATA]
           ([STD_REGISTRY_ID]
           ,[STD_REGISTRY_COHORT_TYPE_ID]
           ,[VALUE]
           ,[COMMENT]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED]
           ,[SELECTED_FLAG])
     VALUES
           (@Current_REGISTRY_ID
           ,@CohortTypeId
           ,NULL
           ,NULL
           ,@Update_USER
           ,@Update_USER
           ,GETDATE()
           ,GETDATE()
           ,1);
END TRY
BEGIN CATCH
 EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID,1,''CRS.usp_Patient_Individual_Add'', @@Error,''Error Adding Individual Patient to registry'', @Update_USER
END CATCH
'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_LABCHEMTESTURGENCY]'
GO
IF OBJECT_ID(N'[CRS].[STD_LABCHEMTESTURGENCY]', 'U') IS NULL
CREATE TABLE [CRS].[STD_LABCHEMTESTURGENCY]
(
[LabChemTestUrgencySID] [int] NULL,
[LabChemTestUrgencyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[Urgency] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UrgencyAbbreviation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LabCollectFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WorkloadOnlyFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HL7Code] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LabCodeSID] [int] NULL,
[LabelPrintFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LabCodeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_Sid] on [CRS].[STD_LABCHEMTESTURGENCY]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_Sid' AND object_id = OBJECT_ID(N'[CRS].[STD_LABCHEMTESTURGENCY]'))
CREATE UNIQUE CLUSTERED INDEX [indx_Sid] ON [CRS].[STD_LABCHEMTESTURGENCY] ([LabChemTestUrgencySID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_SID_LabSid] on [CRS].[STD_LABCHEMTESTURGENCY]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_SID_LabSid' AND object_id = OBJECT_ID(N'[CRS].[STD_LABCHEMTESTURGENCY]'))
CREATE NONCLUSTERED INDEX [indx_SID_LabSid] ON [CRS].[STD_LABCHEMTESTURGENCY] ([LabChemTestUrgencySID], [LabCodeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_LABCHEMTEST]'
GO
IF OBJECT_ID(N'[CRS].[STD_LABCHEMTEST]', 'U') IS NULL
CREATE TABLE [CRS].[STD_LABCHEMTEST]
(
[LABCHEMTESTSID] [int] NOT NULL,
[LABCHEMTESTIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[LABCHEMTESTNAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LABCHEMPRINTTESTNAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NLTNATIONALVALABCODESID] [int] NULL,
[NATIONALVALABCODESID] [int] NULL,
[LABCHEMTESTLOCATION] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LABTESTTYPE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[REQUIREDTESTFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TESTCOST] [smallmoney] NULL,
[SNOMEDPROCEDURESID] [int] NULL,
[HIGHESTLABCHEMTESTURGENCYSID] [int] NULL,
[FORCEDLABCHEMTESTURGENCYSID] [int] NULL,
[DEFAULTSPECIMENSITECPTSID] [int] NULL,
[HCSPCSCPTSID] [int] NULL,
[COLLECTIONSAMPLESID] [int] NULL,
[BILLABLEFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UNIQUECOLLECTIONSAMPLEFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UNIQUEACCESSIONNUMBERFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COLLECTIONSAMPLEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DEFAULTSPECIMENSITECPTIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FORCEDLABCHEMTESTURGENCYIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HCSPCSCPTIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HIGHESTLABCHEMTESTURGENCYIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NATIONALVALABCODEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NLTNATIONALVALABCODEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SNOMEDPROCEDUREIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_PatSid] on [CRS].[STD_LABCHEMTEST]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_PatSid' AND object_id = OBJECT_ID(N'[CRS].[STD_LABCHEMTEST]'))
CREATE UNIQUE CLUSTERED INDEX [indx_PatSid] ON [CRS].[STD_LABCHEMTEST] ([LABCHEMTESTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_PatSid_ETLBatch] on [CRS].[STD_LABCHEMTEST]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_PatSid_ETLBatch' AND object_id = OBJECT_ID(N'[CRS].[STD_LABCHEMTEST]'))
CREATE NONCLUSTERED INDEX [indx_PatSid_ETLBatch] ON [CRS].[STD_LABCHEMTEST] ([LABCHEMTESTSID], [ETLBATCHID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[PATIENT_REGISTRY]'
GO
IF OBJECT_ID(N'[CRS].[PATIENT_REGISTRY]', 'U') IS NULL
CREATE TABLE [CRS].[PATIENT_REGISTRY]
(
[PATIENTSID] [int] NULL,
[PATIENTICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[STD_REGISTRY_ID] [int] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_PatSid_PatICN_RegId] on [CRS].[PATIENT_REGISTRY]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_PatSid_PatICN_RegId' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_REGISTRY]'))
CREATE UNIQUE NONCLUSTERED INDEX [indx_PatSid_PatICN_RegId] ON [CRS].[PATIENT_REGISTRY] ([PATIENTSID], [PATIENTICN], [STD_REGISTRY_ID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [dbo].[usp_EMERGENCYROUTINELABS]'
GO
IF OBJECT_ID(N'[dbo].[usp_EMERGENCYROUTINELABS]', 'P') IS NULL
EXEC sp_executesql N'CREATE PROCEDURE [dbo].[usp_EMERGENCYROUTINELABS] 
(@CURRENT_USER VARCHAR(30), @CURRENT_REGISTRY_ID INT, @REFERRAL_ID INT,@YEAR INT, @MONTH INT)
AS
BEGIN
SET NOCOUNT ON;

	DECLARE @ErrorMsg VARCHAR(MAX);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''usp_EmergencyRoutineLabs'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg AS [ErrorMsg];
		RETURN
	END

  SELECT 
  DATEPART(YEAR,c.LABCHEMCOMPLETEDATETIME) AS [Year]
  ,c.PATIENTSID
  ,cl.LABCHEMTESTNAME
  ,cl.LABCHEMPRINTTESTNAME
  ,c.LABCHEMCOMPLETEDATETIME
  ,c.LABCHEMRESULTVALUE
  ,c.LABCHEMRESULTNUMERICVALUE
  ,c.UNITS
  ,c.ABNORMAL
  ,c.REFHIGH
  ,c.REFLOW
  ,CASE WHEN cu.urgency LIKE ''stat%'' THEN  ''Emergency'' 
        WHEN cu.urgency LIKE ''routine%'' THEN ''Routine'' END AS [LabType]
  FROM crs.CHEM_LABCHEM AS c WITH (NOLOCK)
  INNER JOIN [CRS].[STD_LABCHEMTEST] AS cl  ON cl.LABCHEMTESTSID = c.LABCHEMTESTSID
  INNER JOIN [CRS].[STD_LABCHEMTESTURGENCY] AS cu ON cu.LabChemTestUrgencySID = cl.[HIGHESTLABCHEMTESTURGENCYSID]
      OR cu.LabChemTestUrgencySID = cl.[FORCEDLABCHEMTESTURGENCYSID] 
  INNER JOIN crs.PATIENT_REGISTRY AS pr ON pr.PATIENTSID = c.PATIENTSID
    WHERE  ((DATEPART(YEAR,c.LABCHEMCOMPLETEDATETIME) >= @YEAR AND  DATEPART(month,c.LABCHEMCOMPLETEDATETIME) =@MONTH)
	AND pr.STD_REGISTRY_ID = @CURRENT_REGISTRY_ID
	AND (cu.urgency LIKE ''stat%'' or cu.urgency LIKE ''routine%''))
END    
'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[INPAT_INPATIENTICDPROCEDURE]'
GO
IF OBJECT_ID(N'[CRS].[INPAT_INPATIENTICDPROCEDURE]', 'U') IS NULL
CREATE TABLE [CRS].[INPAT_INPATIENTICDPROCEDURE]
(
[InpatientICDProcedureSID] [bigint] NULL,
[PTFIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PTFChild_45_05IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[OrdinalNumber] [smallint] NULL,
[Sta3n] [smallint] NULL,
[PatientSID] [int] NULL,
[InpatientSID] [bigint] NULL,
[AdmitDateTime] [datetime2] NULL,
[AdmitVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AdmitDateTimeTransformSID] [bigint] NULL,
[AdmitDateSID] [int] NULL,
[DischargeDateTime] [datetime2] NULL,
[DIschargeVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DischargeDateTimeTransformSID] [bigint] NULL,
[DischargeDateSID] [int] NULL,
[ICD9ProcedureSID] [int] NULL,
[ICD10ProcedureSID] [int] NULL,
[ICDProcedureDateTime] [datetime2] NULL,
[ICDProcedureVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDProcedureDateTimeTransformSID] [bigint] NULL,
[ICDProcedureDateSID] [int] NULL,
[DialysisTreatmentCount] [smallint] NULL,
[DialysisTypeSID] [int] NULL,
[SpecialtySID] [int] NULL,
[DialysisTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDProcedureIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SpecialtyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[UPDATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-ETLid] on [CRS].[INPAT_INPATIENTICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-ETLid' AND object_id = OBJECT_ID(N'[CRS].[INPAT_INPATIENTICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-ETLid] ON [CRS].[INPAT_INPATIENTICDPROCEDURE] ([PatientSID], [ETLBatchID], [InpatientICDProcedureSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-DialSid] on [CRS].[INPAT_INPATIENTICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-DialSid' AND object_id = OBJECT_ID(N'[CRS].[INPAT_INPATIENTICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-DialSid] ON [CRS].[INPAT_INPATIENTICDPROCEDURE] ([PatientSID], [DialysisTypeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-DialSid] on [CRS].[INPAT_INPATIENTICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-DialSid' AND object_id = OBJECT_ID(N'[CRS].[INPAT_INPATIENTICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-DialSid] ON [CRS].[INPAT_INPATIENTICDPROCEDURE] ([DialysisTypeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[INPAT_CENSUSICDPROCEDURE]'
GO
IF OBJECT_ID(N'[CRS].[INPAT_CENSUSICDPROCEDURE]', 'U') IS NULL
CREATE TABLE [CRS].[INPAT_CENSUSICDPROCEDURE]
(
[CensusICDProcedureSID] [bigint] NULL,
[PTFIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PTFChild_45_05IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[OrdinalNumber] [smallint] NULL,
[Sta3n] [smallint] NULL,
[CensusSID] [bigint] NULL,
[PatientSID] [int] NULL,
[ParentFeeBasisFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AdmitDateTime] [datetime2] NULL,
[AdmitVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AdmitDateTimeTransformSID] [bigint] NULL,
[AdmitDateSID] [int] NULL,
[CensusDateTime] [datetime2] NULL,
[CensusVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CensusDateTimeTransformSID] [bigint] NULL,
[CensusDateSID] [int] NULL,
[ICD9ProcedureSID] [int] NULL,
[ICD10ProcedureSID] [int] NULL,
[ICDProcedureDateTime] [datetime2] NULL,
[ICDProcedureVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDProcedureDateTimeTransformSID] [bigint] NULL,
[ICDProcedureDateSID] [int] NULL,
[DialysisTreatmentCount] [smallint] NULL,
[DialysisTypeSID] [int] NULL,
[SpecialtySID] [int] NULL,
[DialysisTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDProcedureIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SpecialtyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[UPDATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID-ETLid] on [CRS].[INPAT_CENSUSICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID-ETLid' AND object_id = OBJECT_ID(N'[CRS].[INPAT_CENSUSICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-SID-ETLid] ON [CRS].[INPAT_CENSUSICDPROCEDURE] ([CensusICDProcedureSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-ETLid] on [CRS].[INPAT_CENSUSICDPROCEDURE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-ETLid' AND object_id = OBJECT_ID(N'[CRS].[INPAT_CENSUSICDPROCEDURE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-ETLid] ON [CRS].[INPAT_CENSUSICDPROCEDURE] ([PatientSID], [DialysisTypeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[DialysisType]'
GO
IF OBJECT_ID(N'[CRS].[DialysisType]', 'U') IS NULL
CREATE TABLE [CRS].[DialysisType]
(
[DialysisTypeSID] [int] NULL,
[DialysisTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[DialysisTypeDescription] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DialysisTypeCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[UPDATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-Sid] on [CRS].[DialysisType]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-Sid' AND object_id = OBJECT_ID(N'[CRS].[DialysisType]'))
CREATE CLUSTERED INDEX [ClusteredIndex-Sid] ON [CRS].[DialysisType] ([DialysisTypeSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid-Type] on [CRS].[DialysisType]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid-Type' AND object_id = OBJECT_ID(N'[CRS].[DialysisType]'))
CREATE UNIQUE NONCLUSTERED INDEX [NonClusteredIndex-Sid-Type] ON [CRS].[DialysisType] ([DialysisTypeSID], [DialysisTypeDescription])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-] on [CRS].[DialysisType]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-' AND object_id = OBJECT_ID(N'[CRS].[DialysisType]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-] ON [CRS].[DialysisType] ([DialysisTypeDescription])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[usp_HEMODIALYSIS]'
GO
IF OBJECT_ID(N'[CRS].[usp_HEMODIALYSIS]', 'P') IS NULL
EXEC sp_executesql N'
  CREATE PROC [CRS].[usp_HEMODIALYSIS] AS   
  /*
  Created by: WAL
  DATE: 02/15/2018
  RTC#362351
  */
	   SELECT 
       DISTINCT
	   ISNULL(c.PatientSid,d.PatientSid) AS PatientSid
	  ,b.PatientFirstName
	  ,b.PatientLastName
	  ,b.ScrSSN
	  ,b.DateofDeath
      ,a.[DialysisTypeSID]
      ,a.[DialysisTypeDescription]
      ,a.[DialysisTypeCode]
	  ,c.[AdmitDateTime]
      ,c.[DischargeDateTime]
	  ,c.[AdmitVistaErrorDate]
      ,c.[DIschargeVistaErrorDate]
FROM [CRS].[CRS].[DialysisType] AS a
LEFT JOIN CRS.[CRS].[INPAT_INPATIENTICDPROCEDURE]  AS c ON c.DialysisTypeSID = a.DialysisTypeSID
          AND c.patientsid IS NOT NULL 
LEFT JOIN CRS.[CRS].[INPAT_CENSUSICDPROCEDURE] AS d ON d.DialysisTypeSID = a.DialysisTypeSID
          AND d.patientsid IS NOT NULL
INNER JOIN CRS.SPATIENT AS b ON c.patientsid = b.patientsid 
WHERE a.dialysistypedescription LIKE ''%hemodialysis%''
ORDER BY  patientsid,c.AdmitDateTime DESC



'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[usp_PERITONEAL]'
GO
IF OBJECT_ID(N'[CRS].[usp_PERITONEAL]', 'P') IS NULL
EXEC sp_executesql N'  CREATE PROC [CRS].[usp_PERITONEAL] AS   
  /*
  Created by: WAL
  DATE: 02/15/2018
  RTC#
  */
	   SELECT 
       DISTINCT
	  ISNULL(c.PatientSid,d.PatientSid) AS PatientSid
	  ,b.PatientFirstName
	  ,b.PatientLastName
	  ,b.ScrSSN
	  ,b.DateofDeath
      ,a.[DialysisTypeSID]
      ,a.[DialysisTypeDescription]
      ,a.[DialysisTypeCode]
	  ,c.[AdmitDateTime]
      ,c.[DischargeDateTime]
	  ,c.[AdmitVistaErrorDate]
      ,c.[DIschargeVistaErrorDate]
FROM [CRS].[CRS].[DialysisType] AS a
LEFT JOIN CRS.[CRS].[INPAT_INPATIENTICDPROCEDURE]  AS c ON c.DialysisTypeSID = a.DialysisTypeSID
          AND c.patientsid IS NOT NULL 
LEFT JOIN CRS.[CRS].[INPAT_CENSUSICDPROCEDURE] AS d ON d.DialysisTypeSID = a.DialysisTypeSID
          AND d.patientsid IS NOT NULL
INNER JOIN CRS.SPATIENT AS b ON c.patientsid = b.patientsid OR  d.patientsid = b.patientsid
WHERE a.dialysistypedescription LIKE ''%PERITONEAL%''
      
ORDER BY  patientsid,c.AdmitDateTime DESC


'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[Patient_Master]'
GO
IF OBJECT_ID(N'[CRS].[Patient_Master]', 'U') IS NULL
CREATE TABLE [CRS].[Patient_Master]
(
[PatientICN] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[PatientID] [bigint] NULL,
[PK_ID] [int] NULL,
[PatientSID] [int] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_Patient_Master] on [CRS].[Patient_Master]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'PK_Patient_Master' AND object_id = OBJECT_ID(N'[CRS].[Patient_Master]'))
ALTER TABLE [CRS].[Patient_Master] ADD CONSTRAINT [PK_Patient_Master] PRIMARY KEY CLUSTERED  ([PatientICN])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [idx_CRS_Patient_Master_PKID] on [CRS].[Patient_Master]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'idx_CRS_Patient_Master_PKID' AND object_id = OBJECT_ID(N'[CRS].[Patient_Master]'))
CREATE NONCLUSTERED INDEX [idx_CRS_Patient_Master_PKID] ON [CRS].[Patient_Master] ([PK_ID]) INCLUDE ([PatientICN])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[usp_REFERRAL_getitemsCommonByRegistry_Test]'
GO
IF OBJECT_ID(N'[CRS].[usp_REFERRAL_getitemsCommonByRegistry_Test]', 'P') IS NULL
EXEC sp_executesql N'


-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Registry and Status
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
CREATE PROCEDURE [CRS].[usp_REFERRAL_getitemsCommonByRegistry_Test] (
@CURRENT_USER varchar(30)
, @CURRENT_REGISTRY_ID int
, @SEARCH_COLUMN varchar(100) = ''''
, @SEARCH_TEXT varchar(100) = ''''
, @SORT_EXPRESSION varchar(100) = ''''
, @START_ROW int = 1
, @MAX_ROWS int = 10)
AS
BEGIN
--drop table #temppatient
--create table #temppatient (stdregistryid int,patienticn varchar(12),pk_id int )
--Create Clustered index IDX_PKID_TEMP on #temppatient (stdregistryid, patienticn,pk_id);
--INSERT #temppatient
--select stdregistryid,patienticn,max(pk_id) pk_id
--from crs.spatient
--where stdregistryid  = 5--@CURRENT_REGISTRY_ID
--group by stdregistryid,patienticn
--select * from #temppatient

									--order by stdregistryid,patienticn,pk_id)

	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_REFERRAL_getitemsByRegistryStatus'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	IF (@START_ROW = 0)
		SET @START_ROW = 1;

	IF (LTRIM(RTRIM(@SEARCH_TEXT)) = '''')
		SET @SEARCH_COLUMN = '''';

	DECLARE @ReferralTable1 TABLE 
	(
		[REFERRAL_PROVIDER_ID] int
		,[REFERRAL_REFERRAL_DATE] datetime
		,[REFERRAL_REFERRAL_ID] int
		,[REFERRAL_PATIENT_ID] int
		,[STD_REGISTRY_NAME] varchar(100)
		,[PATIENT_BIRTH_DATE] datetime
		,[PATIENT_FIRST_NAME] varchar(50)
		,[PATIENT_LAST_NAME] varchar(50)
		,[STD_REFERRALSTS_CODE] varchar(50)
		,[SPATIENT_City] varchar(50)
		,[SPATIENT_Gender] char(1)
		,[SPATIENT_PostalCode] varchar(50)
		,[SPATIENT_State] varchar(30)
		,[SPATIENT_PatientLastFour] varchar(4));

	--First filter out duplicates
	INSERT INTO @ReferralTable1 ([REFERRAL_PROVIDER_ID],[REFERRAL_REFERRAL_DATE],[REFERRAL_REFERRAL_ID],[REFERRAL_PATIENT_ID],[STD_REGISTRY_NAME],[PATIENT_BIRTH_DATE],[PATIENT_FIRST_NAME],[PATIENT_LAST_NAME],[STD_REFERRALSTS_CODE],[SPATIENT_City],[SPATIENT_Gender],[SPATIENT_PostalCode],[SPATIENT_State],[SPATIENT_PatientLastFour])
	SELECT
		[REFERRAL_PROVIDER_ID]
		,[REFERRAL_REFERRAL_DATE]
		,[REFERRAL_REFERRAL_ID]
		,[REFERRAL_PATIENT_ID]
		,[STD_REGISTRY_NAME]
		,[PATIENT_BIRTH_DATE]
		,[PATIENT_FIRST_NAME]
		,[PATIENT_LAST_NAME]
		,[STD_REFERRALSTS_CODE]
		,[SPATIENT_City]
		,[SPATIENT_Gender]
		,[SPATIENT_PostalCode]
		,[SPATIENT_State]
		,[SPATIENT_PatientLastFour]
	FROM (
		SELECT 
			ROW_NUMBER() OVER(PARTITION BY [CRS].[REFERRAL].[REFERRAL_ID] ORDER BY [CRS].[REFERRAL].[REFERRAL_ID] DESC) AS [Row]
			,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
			,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
			,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
			,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]

			,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]

			,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
			,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
			,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]

			,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]

			,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
			,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
			,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip])  AS [SPATIENT_PostalCode]
			,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
			,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], ''0000''), 4) AS [SPATIENT_PatientLastFour]
		
		from 
			[CRS].[REFERRAL]
		        INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[REFERRAL].[STD_REGISTRY_ID] = [CRS].[STD_REGISTRY].[ID]
			
				INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[REFERRAL].[STD_REFERRALSTS_ID] = [CRS].[STD_REFERRALSTS].[ID] 
				INNER JOIN [CRS].[PATIENT] ON [CRS].[REFERRAL].[PATIENT_ID] = [CRS].[PATIENT].[Patient_ID]
				JOIN [CRS].[Patient_Master] ON [CRS].[REFERRAL].[Patient_ID] = [CRS].[Patient_Master].[PatientID]
				JOIN [CRS].[sPatient] on [CRS].[Patient_Master].pk_id = [CRS].[sPatient].pk_ID  --and [CRS].[Patient_Master].PatientICN = [CRS].[sPatient].PatientICN 
									 
			--INNER JOIN #temppatient t on  t.[PatientICN] = [CRS].[PATIENT].[PatientICN] 
			--INNER JOIN [CRS].[sPATIENT] ON  t.stdregistryid = [CRS].[sPATIENT].[stdregistryid] AND
			--   t.[PatientICN] = [CRS].[sPATIENT].[PatientICN] and
			--  t.pk_id = [CRS].[sPATIENT].[pk_id]  

			--INNER JOIN (select stdregistryid,patienticn,max(pk_id) pk_id
			--					from crs.spatient
			--					where stdregistryid = @CURRENT_REGISTRY_ID
			--					group by stdregistryid,patienticn) as t on  t.[PatientICN] = [CRS].[PATIENT].[PatientICN] 
			--     INNER JOIN [CRS].[sPATIENT] ON  t.stdregistryid =  [CRS].[sPATIENT].[stdregistryid] AND
			--	  t.[PatientICN] = [CRS].[sPATIENT].[PatientICN] and
			--t.pk_id = [CRS].[sPATIENT].[pk_id]  
		WHERE 
			[CRS].[REFERRAL].[STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID
			AND (ISNULL(@SEARCH_COLUMN, '''') = '''' 
					OR (@SEARCH_COLUMN = ''STD_REFERRALSTS_CODE'' AND [CRS].[STD_REFERRALSTS].[CODE] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''REFERRAL_DATE'' AND [CRS].[REFERRAL].[REFERRAL_DATE] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_LastFour'' AND RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], ''0000''), 4) LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_LAST_NAME'' AND [CRS].[PATIENT].[LAST_NAME] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_FIRST_NAME'' AND [CRS].[PATIENT].[FIRST_NAME] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_BIRTH_DATE'' AND [CRS].[PATIENT].[BIRTH_DATE] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_Gender'' AND [CRS].[SPATIENT].[Gender] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_City'' AND [CRS].[SPATIENT].[City] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_State'' AND [CRS].[SPATIENT].[State] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_PostalCode'' AND ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip]) LIKE ''%'' + @SEARCH_TEXT + ''%'')
				)
	) t
	WHERE t.[Row] = 1;

	--Order and limit records returned
	SELECT 
		[REFERRAL_PROVIDER_ID]
		,[REFERRAL_REFERRAL_DATE]
		,[REFERRAL_REFERRAL_ID]
		,[REFERRAL_PATIENT_ID]
		,[STD_REGISTRY_NAME]
		,[PATIENT_BIRTH_DATE]
		,[PATIENT_FIRST_NAME]
		,[PATIENT_LAST_NAME]
		,[STD_REFERRALSTS_CODE]
		,[SPATIENT_City]
		,[SPATIENT_Gender]
		,[SPATIENT_PostalCode]
		,[SPATIENT_State]
		,[SPATIENT_PatientLastFour] 
	FROM (
		SELECT 
			ROW_NUMBER() OVER(ORDER BY 
				(CASE
					WHEN @SORT_EXPRESSION = ''REFERRAL_DATE'' THEN [REFERRAL_REFERRAL_DATE]
					WHEN @SORT_EXPRESSION = ''PATIENT_BIRTH_DATE'' THEN [PATIENT_BIRTH_DATE] 
				END) ASC
				,(CASE
					WHEN @SORT_EXPRESSION = ''REFERRAL_DATE DESC'' THEN [REFERRAL_REFERRAL_DATE]
					WHEN @SORT_EXPRESSION = ''PATIENT_BIRTH_DATE DESC'' THEN [PATIENT_BIRTH_DATE] 
				END) DESC
				,(CASE
					WHEN @SORT_EXPRESSION = ''PATIENT_FIRST_NAME'' THEN [PATIENT_FIRST_NAME]
					WHEN @SORT_EXPRESSION = ''PATIENT_LAST_NAME'' THEN [PATIENT_LAST_NAME]
					WHEN @SORT_EXPRESSION = ''STD_REFERRALSTS_CODE'' THEN [STD_REFERRALSTS_CODE]
					WHEN @SORT_EXPRESSION = ''PATIENT_City'' THEN [SPATIENT_City]
					WHEN @SORT_EXPRESSION = ''PATIENT_Gender'' THEN [SPATIENT_Gender]
					WHEN @SORT_EXPRESSION = ''PATIENT_PostalCode'' THEN [SPATIENT_PostalCode]
					WHEN @SORT_EXPRESSION = ''PATIENT_State'' THEN [SPATIENT_State]
					WHEN @SORT_EXPRESSION = ''PATIENT_LastFour'' THEN [SPATIENT_PatientLastFour]
				END) ASC
				,(CASE
					WHEN @SORT_EXPRESSION = ''PATIENT_FIRST_NAME DESC'' THEN [PATIENT_FIRST_NAME]
					WHEN @SORT_EXPRESSION = ''PATIENT_LAST_NAME DESC'' THEN [PATIENT_LAST_NAME]
					WHEN @SORT_EXPRESSION = ''STD_REFERRALSTS_CODE DESC'' THEN [STD_REFERRALSTS_CODE]
					WHEN @SORT_EXPRESSION = ''PATIENT_City DESC'' THEN [SPATIENT_City]
					WHEN @SORT_EXPRESSION = ''PATIENT_Gender DESC'' THEN [SPATIENT_Gender]
					WHEN @SORT_EXPRESSION = ''PATIENT_PostalCode DESC'' THEN [SPATIENT_PostalCode]
					WHEN @SORT_EXPRESSION = ''PATIENT_State DESC'' THEN [SPATIENT_State]
					WHEN @SORT_EXPRESSION = ''PATIENT_LastFour DESC'' THEN [SPATIENT_PatientLastFour]
				END) DESC) AS [Num]
			,[REFERRAL_PROVIDER_ID]
			,[REFERRAL_REFERRAL_DATE]
			,[REFERRAL_REFERRAL_ID]
			,[REFERRAL_PATIENT_ID]
			,[STD_REGISTRY_NAME]
			,[PATIENT_BIRTH_DATE]
			,[PATIENT_FIRST_NAME]
			,[PATIENT_LAST_NAME]
			,[STD_REFERRALSTS_CODE]
			,[SPATIENT_City]
			,[SPATIENT_Gender]
			,[SPATIENT_PostalCode]
			,[SPATIENT_State]
			,[SPATIENT_PatientLastFour] 
		FROM @ReferralTable1
	) t
	WHERE t.[NUM] >= @START_ROW AND t.[NUM] < (@START_ROW + @MAX_ROWS);

END



'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[usp_PATIENT_getitemsCommonByRegistry_Test]'
GO
IF OBJECT_ID(N'[CRS].[usp_PATIENT_getitemsCommonByRegistry_Test]', 'P') IS NULL
EXEC sp_executesql N'

-- =============================================
-- Author:        
-- Create date:   12/28/2015
-- Description:   Get all records by Registry and Status
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATIENT_getitemsCommonByRegistry_Test] (
@CURRENT_USER varchar(30)
, @CURRENT_REGISTRY_ID int
, @SEARCH_COLUMN varchar(100) = ''''
, @SEARCH_TEXT varchar(100) = ''''
, @SORT_EXPRESSION varchar(100) = ''''
, @START_ROW int = 1
, @MAX_ROWS int = 10)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PATIENT_getitemsCommonByRegistry'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	IF (@START_ROW = 0)
		SET @START_ROW = 1;

	IF (LTRIM(RTRIM(@SEARCH_TEXT)) = '''')
		SET @SEARCH_COLUMN = '''';

	DECLARE @ReferralTable1 TABLE 
	(
		[REFERRAL_PROVIDER_ID] int
		,[REFERRAL_REFERRAL_DATE] datetime
		,[REFERRAL_REFERRAL_ID] int
		,[REFERRAL_PATIENT_ID] int
		,[STD_REGISTRY_NAME] varchar(100)
		,[PATIENT_BIRTH_DATE] datetime
		,[PATIENT_FIRST_NAME] varchar(50)
		,[PATIENT_LAST_NAME] varchar(50)
		,[STD_REFERRALSTS_CODE] varchar(50)
		,[SPATIENT_City] varchar(50)
		,[SPATIENT_Gender] char(1)
		,[SPATIENT_PostalCode] varchar(50)
		,[SPATIENT_State] varchar(30)
		,[SPATIENT_PatientLastFour] varchar(4));

	--First filter out duplicates
	INSERT INTO @ReferralTable1 ([REFERRAL_PROVIDER_ID],[REFERRAL_REFERRAL_DATE],[REFERRAL_REFERRAL_ID],[REFERRAL_PATIENT_ID],[STD_REGISTRY_NAME],[PATIENT_BIRTH_DATE],[PATIENT_FIRST_NAME],[PATIENT_LAST_NAME],[STD_REFERRALSTS_CODE],[SPATIENT_City],[SPATIENT_Gender],[SPATIENT_PostalCode],[SPATIENT_State],[SPATIENT_PatientLastFour])
	SELECT
		[REFERRAL_PROVIDER_ID]
		,[REFERRAL_REFERRAL_DATE]
		,[REFERRAL_REFERRAL_ID]
		,[REFERRAL_PATIENT_ID]
		,[STD_REGISTRY_NAME]
		,[PATIENT_BIRTH_DATE]
		,[PATIENT_FIRST_NAME]
		,[PATIENT_LAST_NAME]
		,[STD_REFERRALSTS_CODE]
		,[SPATIENT_City]
		,[SPATIENT_Gender]
		,[SPATIENT_PostalCode]
		,[SPATIENT_State]
		,[SPATIENT_PatientLastFour]
	FROM (
		SELECT TOP 1000
			ROW_NUMBER() OVER(PARTITION BY [CRS].[REFERRAL].[PATIENT_ID] ORDER BY [CRS].[REFERRAL].[PATIENT_ID] DESC) AS [Row]
			,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID]
			,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE]
			,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID]
			,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID]

			,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME]

			,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
			,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
			,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]

			,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE]

			,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
			,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
			,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip])  AS [SPATIENT_PostalCode]
			,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
			,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], ''0000''), 4) AS [SPATIENT_PatientLastFour]
		FROM 
			[CRS].[REFERRAL]
				INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
				INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
				INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[STD_REFERRALSTS].[ID] = [CRS].[REFERRAL].[STD_REFERRALSTS_ID]
				LEFT OUTER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
		WHERE 
			[CRS].[REFERRAL].[STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID
			AND (ISNULL(@SEARCH_COLUMN, '''') = '''' 
					OR (@SEARCH_COLUMN = ''PATIENT_ID'' AND [CRS].[REFERRAL].[PATIENT_ID] = @SEARCH_TEXT)
					OR (@SEARCH_COLUMN = ''REFERRAL_ID'' AND [CRS].[REFERRAL].[REFERRAL_ID] = @SEARCH_TEXT)
					OR (@SEARCH_COLUMN = ''PROVIDER_ID'' AND [CRS].[REFERRAL].[PROVIDER_ID] = @SEARCH_TEXT)
					OR (@SEARCH_COLUMN = ''STD_REFERRALSTS_CODE'' AND [CRS].[STD_REFERRALSTS].[CODE] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''REFERRAL_DATE'' AND [CRS].[REFERRAL].[REFERRAL_DATE] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_LastFour'' AND RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], ''0000''), 4) LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_LAST_NAME'' AND [CRS].[PATIENT].[LAST_NAME] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_FIRST_NAME'' AND [CRS].[PATIENT].[FIRST_NAME] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_BIRTH_DATE'' AND [CRS].[PATIENT].[BIRTH_DATE] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_Gender'' AND [CRS].[SPATIENT].[Gender] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_City'' AND [CRS].[SPATIENT].[City] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_State'' AND [CRS].[SPATIENT].[State] LIKE ''%'' + @SEARCH_TEXT + ''%'')
					OR (@SEARCH_COLUMN = ''PATIENT_PostalCode'' AND ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip]) LIKE ''%'' + @SEARCH_TEXT + ''%'')
				)
	) t
	WHERE t.[Row] = 1;

	--Order and limit records returned
	SELECT
		[REFERRAL_PROVIDER_ID]
		,[REFERRAL_REFERRAL_DATE]
		,[REFERRAL_REFERRAL_ID]
		,[REFERRAL_PATIENT_ID]
		,[STD_REGISTRY_NAME]
		,[PATIENT_BIRTH_DATE]
		,[PATIENT_FIRST_NAME]
		,[PATIENT_LAST_NAME]
		,[STD_REFERRALSTS_CODE]
		,[SPATIENT_City]
		,[SPATIENT_Gender]
		,[SPATIENT_PostalCode]
		,[SPATIENT_State]
		,[SPATIENT_PatientLastFour] 
	FROM (
		SELECT 
			ROW_NUMBER() OVER(ORDER BY 
				(CASE
					WHEN @SORT_EXPRESSION = ''PATIENT_ID'' THEN [REFERRAL_PATIENT_ID]
					WHEN @SORT_EXPRESSION = ''REFERRAL_ID'' THEN [REFERRAL_REFERRAL_ID] 
					WHEN @SORT_EXPRESSION = ''PROVIDER_ID'' THEN [REFERRAL_PROVIDER_ID] 
				END) ASC
				,(CASE
					WHEN @SORT_EXPRESSION = ''PATIENT_ID DESC'' THEN [REFERRAL_PATIENT_ID]
					WHEN @SORT_EXPRESSION = ''REFERRAL_ID DESC'' THEN [REFERRAL_REFERRAL_ID] 
					WHEN @SORT_EXPRESSION = ''PROVIDER_ID DESC'' THEN [REFERRAL_PROVIDER_ID] 
				END) DESC
				,(CASE
					WHEN @SORT_EXPRESSION = ''REFERRAL_DATE'' THEN [REFERRAL_REFERRAL_DATE]
					WHEN @SORT_EXPRESSION = ''PATIENT_BIRTH_DATE'' THEN [PATIENT_BIRTH_DATE] 
				END) ASC
				,(CASE
					WHEN @SORT_EXPRESSION = ''REFERRAL_DATE DESC'' THEN [REFERRAL_REFERRAL_DATE]
					WHEN @SORT_EXPRESSION = ''PATIENT_BIRTH_DATE DESC'' THEN [PATIENT_BIRTH_DATE] 
				END) DESC
				,(CASE
					WHEN @SORT_EXPRESSION = ''PATIENT_FIRST_NAME'' THEN [PATIENT_FIRST_NAME]
					WHEN @SORT_EXPRESSION = ''PATIENT_LAST_NAME'' THEN [PATIENT_LAST_NAME]
					WHEN @SORT_EXPRESSION = ''STD_REFERRALSTS_CODE'' THEN [STD_REFERRALSTS_CODE]
					WHEN @SORT_EXPRESSION = ''PATIENT_City'' THEN [SPATIENT_City]
					WHEN @SORT_EXPRESSION = ''PATIENT_Gender'' THEN [SPATIENT_Gender]
					WHEN @SORT_EXPRESSION = ''PATIENT_PostalCode'' THEN [SPATIENT_PostalCode]
					WHEN @SORT_EXPRESSION = ''PATIENT_State'' THEN [SPATIENT_State]
					WHEN @SORT_EXPRESSION = ''PATIENT_LastFour'' THEN [SPATIENT_PatientLastFour]
				END) ASC
				,(CASE
					WHEN @SORT_EXPRESSION = ''PATIENT_FIRST_NAME DESC'' THEN [PATIENT_FIRST_NAME]
					WHEN @SORT_EXPRESSION = ''PATIENT_LAST_NAME DESC'' THEN [PATIENT_LAST_NAME]
					WHEN @SORT_EXPRESSION = ''STD_REFERRALSTS_CODE DESC'' THEN [STD_REFERRALSTS_CODE]
					WHEN @SORT_EXPRESSION = ''PATIENT_City DESC'' THEN [SPATIENT_City]
					WHEN @SORT_EXPRESSION = ''PATIENT_Gender DESC'' THEN [SPATIENT_Gender]
					WHEN @SORT_EXPRESSION = ''PATIENT_PostalCode DESC'' THEN [SPATIENT_PostalCode]
					WHEN @SORT_EXPRESSION = ''PATIENT_State DESC'' THEN [SPATIENT_State]
					WHEN @SORT_EXPRESSION = ''PATIENT_LastFour DESC'' THEN [SPATIENT_PatientLastFour]
				END) DESC) AS [Num]
			,[REFERRAL_PROVIDER_ID]
			,[REFERRAL_REFERRAL_DATE]
			,[REFERRAL_REFERRAL_ID]
			,[REFERRAL_PATIENT_ID]
			,[STD_REGISTRY_NAME]
			,[PATIENT_BIRTH_DATE]
			,[PATIENT_FIRST_NAME]
			,[PATIENT_LAST_NAME]
			,[STD_REFERRALSTS_CODE]
			,[SPATIENT_City]
			,[SPATIENT_Gender]
			,[SPATIENT_PostalCode]
			,[SPATIENT_State]
			,[SPATIENT_PatientLastFour] 
		FROM @ReferralTable1
	) t
	WHERE t.[NUM] >= @START_ROW AND t.[NUM] < (@START_ROW + @MAX_ROWS);

END


'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[vw_Patient_Search]'
GO
IF OBJECT_ID(N'[CRS].[vw_Patient_Search]', 'V') IS NULL
EXEC sp_executesql N'

	Create View [CRS].[vw_Patient_Search]
	as
	SELECT   [PATIENT_ICN]				= PM.PatientICN
			,[PATIENT_FIRST_NAME]		= Ltrim(Rtrim(D.[PatientFirstName]))
			,[PATIENT_LAST_NAME]		= ltrim(Rtrim(D.[PatientLastName]))
			,[PATIENT_BIRTH_DATE]		= Cast(D.[DateOfBirth] as date)
			,[SPATIENT_Gender]			= Ltrim(Rtrim(D.[Gender]))
			,[SPATIENT_PostalCode]		= ISNULL(D.[PostalCode],D.[Zip])
			,[SPATIENT_City]			= ltrim(Rtrim(D.[CITY]))
			,[SPATIENT_State]			= ltrim(Rtrim(D.[State]))
			,[SPATIENT_PatientLastFour]	= RIGHT(ISNULL(D.[PatientSSN], ''0000''), 4)
	FROM CRS.Patient_Master		as PM
	JOIN [CRS].[SPATIENT]		as D
		on PM.PK_ID = D.PK_ID'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_ICD10_Code]'
GO
IF OBJECT_ID(N'[CRS].[STD_ICD10_Code]', 'U') IS NULL
CREATE TABLE [CRS].[STD_ICD10_Code]
(
[ICD10SID] [int] NOT NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[ICD10CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10Description] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGIDENTIFIER] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGCONDITIONCOMORBIDITYEXCLUSIONSID] [int] NULL,
[REPRODUCTIVESYSTEMMDC13FLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MULTIPLESIGNIFICANTTRAUMAMDC24] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HIVMDC25] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EXPANDEDICDFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UNACCEPTABLEASPRIMARYFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10POAEXEMPTFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGCONDITIONCOMORBIDITYEXCLUSIONIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDCODINGSYSTEMIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex_STD_ICD10Code_ICD10SID] on [CRS].[STD_ICD10_Code]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex_STD_ICD10Code_ICD10SID' AND object_id = OBJECT_ID(N'[CRS].[STD_ICD10_Code]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex_STD_ICD10Code_ICD10SID] ON [CRS].[STD_ICD10_Code] ([ICD10SID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[COMORBIDICD10DIAGNOSISVERSION]'
GO
IF OBJECT_ID(N'[CRS].[COMORBIDICD10DIAGNOSISVERSION]', 'U') IS NULL
CREATE TABLE [CRS].[COMORBIDICD10DIAGNOSISVERSION]
(
[ComorbidICD10DiagnosisVersionSID] [int] NULL,
[ICD10SID] [int] NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ComorbidICD10DiagnosisVersionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ComplicationComorbidity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PrimaryCategory] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDate] [date] NULL,
[StartEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDateTransformSID] [bigint] NULL,
[EndEffectiveDate] [date] NULL,
[EndEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EndEffectiveDateTransformSID] [bigint] NULL,
[CurrentVersionFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[vw_COMORBIDICD10DIAGNOSIS]'
GO
IF OBJECT_ID(N'[CRS].[vw_COMORBIDICD10DIAGNOSIS]', 'V') IS NULL
EXEC sp_executesql N'
CREATE VIEW [CRS].[vw_COMORBIDICD10DIAGNOSIS] AS
SELECT 
       a.[Sta3n]
      ,a.[ComplicationComorbidity]
      ,a.[PrimaryCategory]
	  ,b.[ICD10CODE]
	  ,b.[ICD10Description]
      ,a.[StartEffectiveDate]
      ,a.[StartEffectiveVistaErrorDate]
      ,a.[StartEffectiveDateTransformSID]
      ,a.[EndEffectiveDate]
      ,a.[EndEffectiveVistaErrorDate]
      ,a.[EndEffectiveDateTransformSID]
      ,a.[CurrentVersionFlag]
      ,a.[VistaCreateDate]
      ,a.[VistaEditDate]
	  ,a.[ICD10SID]
  FROM [CRS].[COMORBIDICD10DIAGNOSISVERSION] AS a
  INNER JOIN [CRS].[STD_ICD10_CODE] AS b ON b.ICD10SID = a.ICD10SID

'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_ICD9_CODE]'
GO
IF OBJECT_ID(N'[CRS].[STD_ICD9_CODE]', 'U') IS NULL
CREATE TABLE [CRS].[STD_ICD9_CODE]
(
[ICD9SID] [int] NOT NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[ICD9CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD9Description] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGIDENTIFIER] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGCONDITIONCOMORBIDITYEXCLUSIONSID] [int] NULL,
[REPRODUCTIVESYSTEMMDC13FLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MULTIPLESIGNIFICANTTRAUMAMDC24] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HIVMDC25] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EXPANDEDICDFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UNACCEPTABLEASPRIMARYFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DRGCONDITIONCOMORBIDITYEXCLUSIONIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDCODINGSYSTEMIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[COMORBIDICD9DIAGNOSISVERSION]'
GO
IF OBJECT_ID(N'[CRS].[COMORBIDICD9DIAGNOSISVERSION]', 'U') IS NULL
CREATE TABLE [CRS].[COMORBIDICD9DIAGNOSISVERSION]
(
[ComorbidICD9DiagnosisVersionSID] [int] NULL,
[ICD9SID] [int] NULL,
[ICDIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ComorbidICD9DiagnosisVersionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ComplicationComorbidity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PrimaryCategory] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDate] [date] NULL,
[StartEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StartEffectiveDateTransformSID] [bigint] NULL,
[EndEffectiveDate] [date] NULL,
[EndEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EndEffectiveDateTransformSID] [bigint] NULL,
[CurrentVersionFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[vw_COMORBIDICD9DIAGNOSIS]'
GO
IF OBJECT_ID(N'[CRS].[vw_COMORBIDICD9DIAGNOSIS]', 'V') IS NULL
EXEC sp_executesql N'
CREATE VIEW  [CRS].[vw_COMORBIDICD9DIAGNOSIS] AS 
Select
       a.[Sta3n]
      ,a.[ComplicationComorbidity]
      ,a.[PrimaryCategory]
	  ,b.[ICD9CODE]
	  ,b.[ICD9Description]
      ,a.[StartEffectiveDate]
      ,a.[StartEffectiveVistaErrorDate]
      ,a.[StartEffectiveDateTransformSID]
      ,a.[EndEffectiveDate]
      ,a.[EndEffectiveVistaErrorDate]
      ,a.[EndEffectiveDateTransformSID]
      ,a.[CurrentVersionFlag]
      ,a.[VistaCreateDate]
      ,a.[VistaEditDate]
	  ,a.[ICD9SID]
  FROM [CRS].[COMORBIDICD9DIAGNOSISVERSION] AS a 
  INNER JOIN [CRS].[STD_ICD9_CODE] AS b ON b.ICD9SID = a.ICD9SID 

'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[vw_InpatientICD10DIAGNOSIS]'
GO
IF OBJECT_ID(N'[CRS].[vw_InpatientICD10DIAGNOSIS]', 'V') IS NULL
EXEC sp_executesql N'CREATE VIEW  [CRS].[vw_InpatientICD10DIAGNOSIS] AS 
SELECT 
       A.[InpatientDiagnosisSID]
      ,A.[PTFIEN]
      ,A.[Sta3n]
      ,A.[OrdinalNumber]
      ,A.[InpatientSID]
      ,A.[PatientSID]
      ,A.[DischargeDateTime]
      ,A.[DischargeVistaErrorDate]
      ,A.[DischargeDateTimeTransformSID]
      ,A.[DischargeDateSID]
      --,A.[ICD9SID]
      ,A.[ICD10SID]
	  ,B.[ICD10CODE]
	  ,B.[ICD10Description]
      ,A.[ETLBatchID]
      ,A.[OpCode]
      ,A.[VistaCreateDate]
      ,A.[VistaEditDate]
      ,A.[StdRegistryId]
      ,A.[CreatedBy]
      ,A.[UpdatedBy]
      ,A.[Created]
      ,A.[Updated]
  FROM 
  [CRS].[INPATIENT_DIAGNOSIS] A
  JOIN [CRS].[STD_ICD10_CODE] B ON A.icd10sid = B.icd10sid
  WHERE B.ICD10CODE in (
''E11.29''
,''I12.0''
,''I12.9''
,''I13.0''
,''I13.10''
,''I13.11''
,''I13.2''
,''I15.0''
,''I70.1''
,''I72.2''
,''I77.3''
,''I82.3''
,''K76.7''
,''N00.3''
,''N00.9''
,''N01.3''
,''N02.2''
,''N02.8''
,''N03.2''
,''N03.3''
,''N03.5''
,''N03.8''
,''N03.9''
,''N04.0''
,''N04.3''
,''N04.4''
,''N04.8''
,''N04.9''
,''N05.2''
,''N05.5''
,''N05.8''
,''N05.9''
,''N08.''
,''N10.''
,''N11.9''
,''N12.''
,''N13.30''
,''N15.9''
,''N17.0''
,''N17.1''
,''N17.2''
,''N17.8''
,''N17.9''
,''N18.1''
,''N18.2''
,''N18.3''
,''N18.4''
,''N18.5''
,''N18.6''
,''N18.9''
,''N19.''
,''N20.0''
,''N25.1''
,''N25.81''
,''N25.89''
,''N26.1''
,''N26.9''
,''N28.1''
,''N28.81''
,''N28.89''
,''N28.9''
,''Q61.02''
,''Q61.3''
,''Q61.5''
,''Q61.9''
,''Q63.8''
,''R88.0''
,''Z49.01''
,''Z49.02''
,''Z49.31''
,''Z49.32''
,''Z91.15''
,''Z94.0''
,''Z99.2'')'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[vw_InpatientICD9DIAGNOSIS]'
GO
IF OBJECT_ID(N'[CRS].[vw_InpatientICD9DIAGNOSIS]', 'V') IS NULL
EXEC sp_executesql N'CREATE VIEW  [CRS].[vw_InpatientICD9DIAGNOSIS] AS 
SELECT 
       A.[InpatientDiagnosisSID]
      ,A.[PTFIEN]
      ,A.[Sta3n]
      ,A.[OrdinalNumber]
      ,A.[InpatientSID]
      ,A.[PatientSID]
      ,A.[DischargeDateTime]
      ,A.[DischargeVistaErrorDate]
      ,A.[DischargeDateTimeTransformSID]
      ,A.[DischargeDateSID]
      ,A.[ICD9SID]
      --,A.[ICD10SID]
	  ,B.[ICD9CODE]
	  ,B.[ICD9Description]
      ,A.[ETLBatchID]
      ,A.[OpCode]
      ,A.[VistaCreateDate]
      ,A.[VistaEditDate]
      ,A.[StdRegistryId]
      ,A.[CreatedBy]
      ,A.[UpdatedBy]
      ,A.[Created]
      ,A.[Updated]
  FROM 
  [CRS].[INPATIENT_DIAGNOSIS] A
  JOIN [CRS].[STD_ICD9_CODE] B ON A.icd9sid = B.icd9sid
  WHERE B.ICD9CODE in (
''016.01''
,''016.03''
,''016.05''
,''095.4''
,''189.0''
,''189.9''
,''223.0''
,''249.41''
,''274.10''
,''283.11''
,''403.01''
,''403.91''
,''404.0''
,''404.02''
,''404.1''
,''404.13''
,''404.9''
,''404.92''
,''447.3''
,''453.3''
,''016.00''
,''016.02''
,''016.04''
,''016.06''
,''236.91''
,''249.40''
,''250.40''
,''250.41''
,''250.42''
,''250.43''
,''271.4''
,''403.0''
,''403.1''
,''403.11''
,''403.9''
,''404.01''
,''404.03''
,''404.11''
,''404.12''
,''404.91''
,''404.93''
,''405.01''
,''440.1''
,''442.1''
,''572.4''
,''580.0''
,''580.4''
,''580.81''
,''580.89''
,''580.9''
,''581.0''
,''581.1''
,''581.2''
,''581.3''
,''581.81''
,''581.89''
,''581.9''
,''582.0''
,''582.1''
,''582.2''
,''582.4''
,''582.81''
,''582.89''
,''582.9''
,''583.0''
,''583.1''
,''583.2''
,''583.4''
,''583.6''
,''583.7''
,''583.81''
,''583.89''
,''583.9''
,''584.5''
,''584.6''
,''584.7''
,''584.8''
,''584.9''
,''585.''
,''585.1''
,''585.2''
,''585.3''
,''585.4''
,''585.5''
,''585.6''
,''585.9''
,''586.''
,''587.''
,''588.0''
,''588.1''
,''588.81''
,''588.89''
,''588.9''
,''589.0''
,''589.1''
,''589.9''
,''590.00''
,''590.01''
,''590.10''
,''590.11''
,''590.80''
,''590.9''
,''591.''
,''592.0''
,''593.0''
,''593.1''
,''593.2''
,''593.3''
,''593.4''
,''593.5''
,''593.6''
,''593.7''
,''593.71''
,''593.72''
,''593.73''
,''593.81''
,''593.89''
,''593.9''
,''642.10''
,''642.11''
,''642.12''
,''642.13''
,''642.14''
,''646.20''
,''646.21''
,''646.22''
,''646.23''
,''646.24''
,''753.0''
,''753.1''
,''753.11''
,''753.12''
,''753.13''
,''753.14''
,''753.15''
,''753.16''
,''753.17''
,''753.19''
,''753.2''
,''753.21''
,''753.22''
,''753.23''
,''753.29''
,''753.3''
,''794.4''
,''V45.1''
,''V45.11''
,''V45.12''
,''V56.0''
,''V56.1''
,''V56.8'')'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[vw_OutPatICD9DIAGNOSIS]'
GO
IF OBJECT_ID(N'[CRS].[vw_OutPatICD9DIAGNOSIS]', 'V') IS NULL
EXEC sp_executesql N'
CREATE VIEW [CRS].[vw_OutPatICD9DIAGNOSIS] AS 
SELECT 
	  A.[VDIAGNOSISSID]
      ,A.[VDIAGNOSISIEN]
      ,A.[STA3N]
      ,A.[ICD9SID]
	  ,B.[ICD9CODE]
	  ,B.[ICD9Description]
      --,A.[ICD10SID]
      ,A.[PATIENTSID]
      ,A.[VISITSID]
      ,A.[EVENTDATETIME]
      ,A.[EVENTVISTAERRORDATE]
      ,A.[EVENTDATETIMETRANSFORMSID]
      ,A.[VISITDATETIME]
      ,A.[VISITVISTAERRORDATE]
      ,A.[VISITDATETIMETRANSFORMSID]
      ,A.[VDIAGNOSISDATETIME]
      ,A.[VDIAGNOSISDATESID]
      ,A.[PROVIDERNARRATIVESID]
      ,A.[MODIFIER]
      ,A.[PRIMARYSECONDARY]
      ,A.[INJURYDATETIME]
      ,A.[INJURYVISTAERRORDATE]
      ,A.[INJURYDATETIMETRANSFORMSID]
      ,A.[CLINICALTERMSID]
      ,A.[PROBLEMLISTSID]
      ,A.[ORDERINGRESULTING]
      ,A.[ORDERINGPROVIDERSID]
      ,A.[ENCOUNTERPROVIDERSID]
      ,A.[SERVICECONNECTEDFLAG]
      ,A.[AGENTORANGEFLAG]
      ,A.[IONIZINGRADIATIONFLAG]
      ,A.[SWASIACONDITIONSFLAG]
      ,A.[MILITARYSEXUALTRAUMAFLAG]
      ,A.[HEADNECKCANCERFLAG]
      ,A.[COMBATFLAG]
      ,A.[SHIPBOARDHAZARDDEFENSEFLAG]
      ,A.[EDITEDFLAG]
      ,A.[AUDITTRAIL]
      ,A.[CATEGORYOFPROVIDERNARRATIVESID]
      ,A.[COMMENTS]
      ,A.[VERIFIED]
      ,A.[VISTAPACKAGESID]
      ,A.[PCEDATASOURCESID]
      ,A.[WORKLOADLOGICFLAG]
      ,A.[ETLBATCHID]
      ,A.[OPCODE]
      ,A.[VISTACREATEDATE]
      ,A.[VISTAEDITDATE]
      ,A.[StdRegistryId]
      ,A.[CreatedBy]
      ,A.[UpdatedBy]
      ,A.[Created]
      ,A.[Updated]
  FROM [CRS].[OUTPAT_VDIAGNOSIS] A 
  JOIN [CRS].[STD_ICD9_CODE] B ON A.icd9sid = B.icd9sid
  WHERE B.ICD9CODE in (
''016.01''
,''016.03''
,''016.05''
,''095.4''
,''189.0''
,''189.9''
,''223.0''
,''249.41''
,''274.10''
,''283.11''
,''403.01''
,''403.91''
,''404.0''
,''404.02''
,''404.1''
,''404.13''
,''404.9''
,''404.92''
,''447.3''
,''453.3''
,''016.00''
,''016.02''
,''016.04''
,''016.06''
,''236.91''
,''249.40''
,''250.40''
,''250.41''
,''250.42''
,''250.43''
,''271.4''
,''403.0''
,''403.1''
,''403.11''
,''403.9''
,''404.01''
,''404.03''
,''404.11''
,''404.12''
,''404.91''
,''404.93''
,''405.01''
,''440.1''
,''442.1''
,''572.4''
,''580.0''
,''580.4''
,''580.81''
,''580.89''
,''580.9''
,''581.0''
,''581.1''
,''581.2''
,''581.3''
,''581.81''
,''581.89''
,''581.9''
,''582.0''
,''582.1''
,''582.2''
,''582.4''
,''582.81''
,''582.89''
,''582.9''
,''583.0''
,''583.1''
,''583.2''
,''583.4''
,''583.6''
,''583.7''
,''583.81''
,''583.89''
,''583.9''
,''584.5''
,''584.6''
,''584.7''
,''584.8''
,''584.9''
,''585.''
,''585.1''
,''585.2''
,''585.3''
,''585.4''
,''585.5''
,''585.6''
,''585.9''
,''586.''
,''587.''
,''588.0''
,''588.1''
,''588.81''
,''588.89''
,''588.9''
,''589.0''
,''589.1''
,''589.9''
,''590.00''
,''590.01''
,''590.10''
,''590.11''
,''590.80''
,''590.9''
,''591.''
,''592.0''
,''593.0''
,''593.1''
,''593.2''
,''593.3''
,''593.4''
,''593.5''
,''593.6''
,''593.7''
,''593.71''
,''593.72''
,''593.73''
,''593.81''
,''593.89''
,''593.9''
,''642.10''
,''642.11''
,''642.12''
,''642.13''
,''642.14''
,''646.20''
,''646.21''
,''646.22''
,''646.23''
,''646.24''
,''753.0''
,''753.1''
,''753.11''
,''753.12''
,''753.13''
,''753.14''
,''753.15''
,''753.16''
,''753.17''
,''753.19''
,''753.2''
,''753.21''
,''753.22''
,''753.23''
,''753.29''
,''753.3''
,''794.4''
,''V45.1''
,''V45.11''
,''V45.12''
,''V56.0''
,''V56.1''
,''V56.8'')'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[vw_OutPatICD10DIAGNOSIS]'
GO
IF OBJECT_ID(N'[CRS].[vw_OutPatICD10DIAGNOSIS]', 'V') IS NULL
EXEC sp_executesql N'
CREATE VIEW [CRS].[vw_OutPatICD10DIAGNOSIS] AS 
SELECT 
	  A.[VDIAGNOSISSID]
      ,A.[VDIAGNOSISIEN]
      ,A.[STA3N]
      --,A.[ICD9SID]
	  ,A.[ICD10SID]
	  ,B.[ICD10CODE]
	  ,B.[ICD10Description]     
      ,A.[PATIENTSID]
      ,A.[VISITSID]
      ,A.[EVENTDATETIME]
      ,A.[EVENTVISTAERRORDATE]
      ,A.[EVENTDATETIMETRANSFORMSID]
      ,A.[VISITDATETIME]
      ,A.[VISITVISTAERRORDATE]
      ,A.[VISITDATETIMETRANSFORMSID]
      ,A.[VDIAGNOSISDATETIME]
      ,A.[VDIAGNOSISDATESID]
      ,A.[PROVIDERNARRATIVESID]
      ,A.[MODIFIER]
      ,A.[PRIMARYSECONDARY]
      ,A.[INJURYDATETIME]
      ,A.[INJURYVISTAERRORDATE]
      ,A.[INJURYDATETIMETRANSFORMSID]
      ,A.[CLINICALTERMSID]
      ,A.[PROBLEMLISTSID]
      ,A.[ORDERINGRESULTING]
      ,A.[ORDERINGPROVIDERSID]
      ,A.[ENCOUNTERPROVIDERSID]
      ,A.[SERVICECONNECTEDFLAG]
      ,A.[AGENTORANGEFLAG]
      ,A.[IONIZINGRADIATIONFLAG]
      ,A.[SWASIACONDITIONSFLAG]
      ,A.[MILITARYSEXUALTRAUMAFLAG]
      ,A.[HEADNECKCANCERFLAG]
      ,A.[COMBATFLAG]
      ,A.[SHIPBOARDHAZARDDEFENSEFLAG]
      ,A.[EDITEDFLAG]
      ,A.[AUDITTRAIL]
      ,A.[CATEGORYOFPROVIDERNARRATIVESID]
      ,A.[COMMENTS]
      ,A.[VERIFIED]
      ,A.[VISTAPACKAGESID]
      ,A.[PCEDATASOURCESID]
      ,A.[WORKLOADLOGICFLAG]
      ,A.[ETLBATCHID]
      ,A.[OPCODE]
      ,A.[VISTACREATEDATE]
      ,A.[VISTAEDITDATE]
      ,A.[StdRegistryId]
      ,A.[CreatedBy]
      ,A.[UpdatedBy]
      ,A.[Created]
      ,A.[Updated]
  FROM [CRS].[OUTPAT_VDIAGNOSIS] A 
  JOIN [CRS].[STD_ICD10_CODE] B ON A.icd10sid = B.icd10sid
    WHERE B.ICD10CODE in (
''E11.29''
,''I12.0''
,''I12.9''
,''I13.0''
,''I13.10''
,''I13.11''
,''I13.2''
,''I15.0''
,''I70.1''
,''I72.2''
,''I77.3''
,''I82.3''
,''K76.7''
,''N00.3''
,''N00.9''
,''N01.3''
,''N02.2''
,''N02.8''
,''N03.2''
,''N03.3''
,''N03.5''
,''N03.8''
,''N03.9''
,''N04.0''
,''N04.3''
,''N04.4''
,''N04.8''
,''N04.9''
,''N05.2''
,''N05.5''
,''N05.8''
,''N05.9''
,''N08.''
,''N10.''
,''N11.9''
,''N12.''
,''N13.30''
,''N15.9''
,''N17.0''
,''N17.1''
,''N17.2''
,''N17.8''
,''N17.9''
,''N18.1''
,''N18.2''
,''N18.3''
,''N18.4''
,''N18.5''
,''N18.6''
,''N18.9''
,''N19.''
,''N20.0''
,''N25.1''
,''N25.81''
,''N25.89''
,''N26.1''
,''N26.9''
,''N28.1''
,''N28.81''
,''N28.89''
,''N28.9''
,''Q61.02''
,''Q61.3''
,''Q61.5''
,''Q61.9''
,''Q63.8''
,''R88.0''
,''Z49.01''
,''Z49.02''
,''Z49.31''
,''Z49.32''
,''Z91.15''
,''Z94.0''
,''Z99.2'')'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[FormatICD9]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[FormatICD9]') AND (type = 'IF' OR type = 'FN' OR type = 'TF'))
EXEC sp_executesql N'

-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [CRS].[FormatICD9] (@CODE varchar(100))
RETURNS varchar(100)
AS
BEGIN
	DECLARE @objReturn varchar(100);
	DECLARE @i int;
	DECLARE @num1 varchar(100);
	DECLARE @num2 varchar(100);

	IF @CODE LIKE ''%V%''
		SET @objReturn = REPLACE(@CODE,''.'','''');
	ELSE IF @CODE LIKE ''%.%''
		BEGIN
			SET @i = CHARINDEX(''.'',@CODE);
			SET @num1 = SUBSTRING(@CODE,0,@i);
			SET @num2 = SUBSTRING(@CODE,@i+1,LEN(@CODE)-@i);

			SET @objReturn = 
			(CASE 
				WHEN LEN(@num1) = 1
					THEN ''00'' + @num1 + @num2
				WHEN LEN(@num1) = 2
					THEN ''0'' + @num1 + @num2
				WHEN LEN(@num1) = 3
					THEN @num1 + @num2
			END);
		END
	ELSE
		BEGIN
			SET @objReturn = 
			(CASE 
				WHEN LEN(@CODE) = 1
					THEN ''00'' + @CODE + ''0''
				WHEN LEN(@CODE) = 2
					THEN ''0'' + @CODE + ''0''
				WHEN LEN(@CODE) = 3
					THEN @CODE + ''0''
			END);
		END

	RETURN @objReturn;
END


'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[GetAgeByDate]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[GetAgeByDate]') AND (type = 'IF' OR type = 'FN' OR type = 'TF'))
EXEC sp_executesql N'

-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date, ,>
-- Description:	<Description, ,>
-- =============================================
CREATE FUNCTION [CRS].[GetAgeByDate] (@BirthDate date)
RETURNS int
AS
BEGIN
	DECLARE @objReturn int;

	SELECT @objReturn = (CONVERT(int,CONVERT(char(8),CURRENT_TIMESTAMP,112))-CONVERT(char(8),@BirthDate,112))/10000

	RETURN @objReturn;
END


'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[ICD10_ICD9_XREF]'
GO
IF OBJECT_ID(N'[CRS].[ICD10_ICD9_XREF]', 'U') IS NULL
CREATE TABLE [CRS].[ICD10_ICD9_XREF]
(
[ICD10] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD9] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FLAGS] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[ICD9_ICD10_XREF]'
GO
IF OBJECT_ID(N'[CRS].[ICD9_ICD10_XREF]', 'U') IS NULL
CREATE TABLE [CRS].[ICD9_ICD10_XREF]
(
[ICD9] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FLAGS] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[PATIENT_CPT]'
GO
IF OBJECT_ID(N'[CRS].[PATIENT_CPT]', 'U') IS NULL
CREATE TABLE [CRS].[PATIENT_CPT]
(
[PATIENTSID] [int] NULL,
[CPTSID] [int] NULL,
[CPTCODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CPTName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CPTDescription] [varchar] (8000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CPTCategory] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MajorCPTCategory] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx-PatSid] on [CRS].[PATIENT_CPT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx-PatSid' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_CPT]'))
CREATE NONCLUSTERED INDEX [indx-PatSid] ON [CRS].[PATIENT_CPT] ([PATIENTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx-PatSid-CPTSID] on [CRS].[PATIENT_CPT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx-PatSid-CPTSID' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_CPT]'))
CREATE NONCLUSTERED INDEX [indx-PatSid-CPTSID] ON [CRS].[PATIENT_CPT] ([PATIENTSID], [CPTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[PATIENT_H]'
GO
IF OBJECT_ID(N'[CRS].[PATIENT_H]', 'U') IS NULL
CREATE TABLE [CRS].[PATIENT_H]
(
[Audit_Patient_H_ID] [int] NOT NULL IDENTITY(1, 1),
[Audit_Date] [datetime] NULL,
[Audit_Type] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Audit_ApplicationUser] [varchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Audit_SQLUser] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_ID] [int] NULL,
[FIRST_NAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MIDDLE_NAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LAST_NAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EMAIL_ADDRESS] [varchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BIRTH_DATE] [date] NULL,
[DEATH_DATE] [date] NULL,
[CELL_PHONE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PERFERRED_ADDRESS_TYPE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[OEFOIF_IND] [bit] NULL,
[PatientICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENTSID] [int] NULL,
[STA3N] [smallint] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_PATIENT_H] on [CRS].[PATIENT_H]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'PK_PATIENT_H' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_H]'))
ALTER TABLE [CRS].[PATIENT_H] ADD CONSTRAINT [PK_PATIENT_H] PRIMARY KEY CLUSTERED  ([Audit_Patient_H_ID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[PATIENT_ICD10]'
GO
IF OBJECT_ID(N'[CRS].[PATIENT_ICD10]', 'U') IS NULL
CREATE TABLE [CRS].[PATIENT_ICD10]
(
[PATIENTSID] [int] NULL,
[ICD10SID] [int] NULL,
[ICD10CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10Description] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_PatSid] on [CRS].[PATIENT_ICD10]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_PatSid' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_ICD10]'))
CREATE NONCLUSTERED INDEX [indx_PatSid] ON [CRS].[PATIENT_ICD10] ([PATIENTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_PatSid_ICD10] on [CRS].[PATIENT_ICD10]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_PatSid_ICD10' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_ICD10]'))
CREATE NONCLUSTERED INDEX [indx_PatSid_ICD10] ON [CRS].[PATIENT_ICD10] ([PATIENTSID], [ICD10CODE])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[PATIENT_ICD9]'
GO
IF OBJECT_ID(N'[CRS].[PATIENT_ICD9]', 'U') IS NULL
CREATE TABLE [CRS].[PATIENT_ICD9]
(
[PATIENTSID] [int] NULL,
[ICD9SID] [int] NULL,
[ICD9CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD9Description] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_PatSid] on [CRS].[PATIENT_ICD9]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_PatSid' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_ICD9]'))
CREATE NONCLUSTERED INDEX [indx_PatSid] ON [CRS].[PATIENT_ICD9] ([PATIENTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [indx_PatSid_ICD9] on [CRS].[PATIENT_ICD9]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'indx_PatSid_ICD9' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_ICD9]'))
CREATE NONCLUSTERED INDEX [indx_PatSid_ICD9] ON [CRS].[PATIENT_ICD9] ([PATIENTSID], [ICD9CODE])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[PATIENT_PROVIDER]'
GO
IF OBJECT_ID(N'[CRS].[PATIENT_PROVIDER]', 'U') IS NULL
CREATE TABLE [CRS].[PATIENT_PROVIDER]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[PROVIDER_ID] [int] NULL,
[STAFFSID] [int] NOT NULL,
[STAFFIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[PATIENTSID] [int] NOT NULL,
[PATIENTICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATED] [datetime] NULL
)
WITH
(
DATA_COMPRESSION = PAGE
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-PatSid-Sid-SIEN-STA] on [CRS].[PATIENT_PROVIDER]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-PatSid-Sid-SIEN-STA' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_PROVIDER]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-PatSid-Sid-SIEN-STA] ON [CRS].[PATIENT_PROVIDER] ([PATIENTSID], [STAFFSID], [STAFFIEN], [STA3N]) WITH (DATA_COMPRESSION = PAGE)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Provider-PatSid] on [CRS].[PATIENT_PROVIDER]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Provider-PatSid' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_PROVIDER]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Provider-PatSid] ON [CRS].[PATIENT_PROVIDER] ([PROVIDER_ID], [PATIENTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid] on [CRS].[PATIENT_PROVIDER]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid' AND object_id = OBJECT_ID(N'[CRS].[PATIENT_PROVIDER]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid] ON [CRS].[PATIENT_PROVIDER] ([PATIENTSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[PATSUB_PATIENTRACE]'
GO
IF OBJECT_ID(N'[CRS].[PATSUB_PATIENTRACE]', 'U') IS NULL
CREATE TABLE [CRS].[PATSUB_PATIENTRACE]
(
[PatientRaceSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientRaceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[PatientSID] [int] NULL,
[RaceSID] [int] NULL,
[Race] [varchar] (45) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CollectionMethodSID] [int] NULL,
[CollectionMethod] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LegacyRaceSID] [int] NULL,
[LegacyRace] [varchar] (45) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CollectionMethodIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LegacyRaceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RaceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
WITH
(
DATA_COMPRESSION = PAGE
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid-PRaceSid-ETLID] on [CRS].[PATSUB_PATIENTRACE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid-PRaceSid-ETLID' AND object_id = OBJECT_ID(N'[CRS].[PATSUB_PATIENTRACE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid-PRaceSid-ETLID] ON [CRS].[PATSUB_PATIENTRACE] ([PatientSID], [PatientRaceSID], [ETLBatchID]) WITH (DATA_COMPRESSION = PAGE)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSID-Race] on [CRS].[PATSUB_PATIENTRACE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSID-Race' AND object_id = OBJECT_ID(N'[CRS].[PATSUB_PATIENTRACE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSID-Race] ON [CRS].[PATSUB_PATIENTRACE] ([PatientSID], [Race]) WITH (DATA_COMPRESSION = PAGE)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[REGISTRY_LOINCCode]'
GO
IF OBJECT_ID(N'[CRS].[REGISTRY_LOINCCode]', 'U') IS NULL
CREATE TABLE [CRS].[REGISTRY_LOINCCode]
(
[LOINCCode_ID] [int] NOT NULL IDENTITY(1, 1),
[REGISTRY_ID] [int] NOT NULL,
[REGISTRYName] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[LOINCCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Component] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[UPDATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CREATED] [datetime] NOT NULL,
[UPDATED] [datetime] NOT NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_REG_LOINCCode] on [CRS].[REGISTRY_LOINCCode]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'PK_REG_LOINCCode' AND object_id = OBJECT_ID(N'[CRS].[REGISTRY_LOINCCode]'))
ALTER TABLE [CRS].[REGISTRY_LOINCCode] ADD CONSTRAINT [PK_REG_LOINCCode] PRIMARY KEY CLUSTERED  ([LOINCCode_ID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[REGISTRY_STOPCode]'
GO
IF OBJECT_ID(N'[CRS].[REGISTRY_STOPCode]', 'U') IS NULL
CREATE TABLE [CRS].[REGISTRY_STOPCode]
(
[StopCode_ID] [int] NOT NULL IDENTITY(1, 1),
[REGISTRY_ID] [int] NOT NULL,
[REGISTRYName] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[StopCode] [smallint] NOT NULL,
[StopCodeName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[UPDATEDBY] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CREATED] [datetime] NOT NULL,
[UPDATED] [datetime] NOT NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating primary key [PK_REG_STOPCode] on [CRS].[REGISTRY_STOPCode]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'PK_REG_STOPCode' AND object_id = OBJECT_ID(N'[CRS].[REGISTRY_STOPCode]'))
ALTER TABLE [CRS].[REGISTRY_STOPCode] ADD CONSTRAINT [PK_REG_STOPCode] PRIMARY KEY CLUSTERED  ([StopCode_ID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[SPATIENT_H]'
GO
IF OBJECT_ID(N'[CRS].[SPATIENT_H]', 'U') IS NULL
CREATE TABLE [CRS].[SPATIENT_H]
(
[Audit_SPatient_H_ID] [int] NOT NULL IDENTITY(1, 1),
[Audit_Date] [datetime] NULL,
[Audit_Type] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Audit_ApplicationUser] [varchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Audit_SQLUser] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Patient_ID] [int] NULL,
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[PatientName] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientLastName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientFirstName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientSSN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ScrSSN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress1] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress2] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress3] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[City] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Zip] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Zip4] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PostalCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Province] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CountrySID] [int] NULL,
[Country] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PhoneResidence] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PhoneWork] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PhoneCellular] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MothersMaidenName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DateOfDeath] [date] NULL,
[DateOfDeathText] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EmailAddress] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BadAddressIndicator] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ExcludeFromFacilityDirectoryFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeInstitutionSID] [int] NULL,
[AddressChangeStaffSID] [int] NULL,
[ConfidentialAddressActiveFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RaceSID] [int] NULL,
[Gender] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Age] [numeric] (18, 0) NULL,
[StateSID] [int] NULL,
[State] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[County] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Deceased] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientICNChecksum] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PseudoSSNFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PeriodOfServiceSID] [int] NULL,
[PeriodOfService] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaritalStatusSID] [int] NULL,
[MaritalStatus] [varchar] (25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PercentServiceConnect] [int] NULL,
[InsuranceCoverageFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReligionSID] [int] NULL,
[Religion] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VeteranFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EnteredIntoFileDate] [date] NULL,
[EnteredIntoFileVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EnteredIntoFileDateTransformSID] [bigint] NULL,
[EligibilitySID] [int] NULL,
[Eligibility] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityVACode] [numeric] (18, 0) NULL,
[DateOfBirth] [date] NULL,
[DateOfBirthText] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SensitiveFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LastServiceEntryDate] [date] NULL,
[LastServiceEntryVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LastServiceEntryDateTransformSID] [bigint] NULL,
[LastServiceSeparationDate] [date] NULL,
[LastServiceSeparationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LastServiceSeparationDateTransformSID] [bigint] NULL,
[CombatFromVistaDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatToVistaDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityVerificationSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISLocatorName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchStatusCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchScore] [int] NULL,
[GISMatchMethodCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchedAddress] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISAddressType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISStreetSide] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISPatientAddressLongitude] [float] NULL,
[GISPatientAddressLatitude] [float] NULL,
[GISAddressUpdatedDate] [date] NULL,
[GISFIPSCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMarket] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISSubmarket] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISSector] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISURH] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISCongressDistrict] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CDDeterminingInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CountryIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CurrentMeansTestStatusIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaritalStatusIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PeriodOfServiceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWLocationIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PreferredInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PurpleHeartInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RaceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReligionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RoomBedIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TemporaryAddressChangeInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[OEF_OIF_IND] [bit] NULL,
[STD_ENTHNICITY_ID] [int] NULL,
[STD_GENDER_ID] [int] NULL,
[STD_MARITALSTATUS_ID] [int] NULL,
[STD_RACE_ID] [int] NULL,
[STD_SERVICEBRANCH_ID] [int] NULL,
[STD_COMBATLOCATION_ID] [int] NULL,
[StdRegistryId] [int] NULL,
[DEFAULT_RECORD] [bit] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updatedate] [datetime] NULL,
[Race] [varchar] (45) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PK_ID] [int] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid] on [CRS].[SPATIENT_H]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_H]'))
CREATE UNIQUE NONCLUSTERED INDEX [NonClusteredIndex-Sid] ON [CRS].[SPATIENT_H] ([Audit_SPatient_H_ID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_PatSid] on [CRS].[SPATIENT_H]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_PatSid' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_H]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Sid_PatSid] ON [CRS].[SPATIENT_H] ([Audit_SPatient_H_ID], [PatientSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[SPATIENT_MILITARYSERVICEEPISODE]'
GO
IF OBJECT_ID(N'[CRS].[SPATIENT_MILITARYSERVICEEPISODE]', 'U') IS NULL
CREATE TABLE [CRS].[SPATIENT_MILITARYSERVICEEPISODE]
(
[MilitaryServiceEpisodeSID] [bigint] NULL,
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MilitaryServiceEpisodeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ServiceEntryDate] [date] NULL,
[ServiceEntryVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceEntryDateTransformSID] [bigint] NULL,
[ServiceSeparationDate] [date] NULL,
[ServiceSeparationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceSeparationDateTransformSID] [bigint] NULL,
[BranchOfServiceSID] [int] NULL,
[ServiceComponent] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DischargeTypeSID] [int] NULL,
[DataLockedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BranchOfServiceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DischargeTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-Sid] on [CRS].[SPATIENT_MILITARYSERVICEEPISODE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-Sid' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_MILITARYSERVICEEPISODE]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-Sid] ON [CRS].[SPATIENT_MILITARYSERVICEEPISODE] ([MilitaryServiceEpisodeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_ETLID] on [CRS].[SPATIENT_MILITARYSERVICEEPISODE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_ETLID' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_MILITARYSERVICEEPISODE]'))
CREATE UNIQUE NONCLUSTERED INDEX [NonClusteredIndex-Sid_ETLID] ON [CRS].[SPATIENT_MILITARYSERVICEEPISODE] ([MilitaryServiceEpisodeSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_PatSid_SepDate] on [CRS].[SPATIENT_MILITARYSERVICEEPISODE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_PatSid_SepDate' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_MILITARYSERVICEEPISODE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Sid_PatSid_SepDate] ON [CRS].[SPATIENT_MILITARYSERVICEEPISODE] ([MilitaryServiceEpisodeSID], [PatientSID], [ServiceSeparationDate])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[SPATIENT_PLACEOFBIRTH]'
GO
IF OBJECT_ID(N'[CRS].[SPATIENT_PLACEOFBIRTH]', 'U') IS NULL
CREATE TABLE [CRS].[SPATIENT_PLACEOFBIRTH]
(
[PlaceOfBirthSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientSID] [int] NULL,
[Sta3n] [smallint] NULL,
[BirthDateTime] [datetime2] NULL,
[BirthVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BirthDateTimeTransformSID] [bigint] NULL,
[MultipleBirthFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientPlaceOfBirthCity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientPlaceOfBirthState] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientPlaceOfBirthStateSID] [int] NULL,
[MotherName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MotherMaidenName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FatherName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientPlaceOfBirthStateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-Sid] on [CRS].[SPATIENT_PLACEOFBIRTH]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-Sid' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_PLACEOFBIRTH]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-Sid] ON [CRS].[SPATIENT_PLACEOFBIRTH] ([PlaceOfBirthSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_ETLID] on [CRS].[SPATIENT_PLACEOFBIRTH]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_ETLID' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_PLACEOFBIRTH]'))
CREATE UNIQUE NONCLUSTERED INDEX [NonClusteredIndex-Sid_ETLID] ON [CRS].[SPATIENT_PLACEOFBIRTH] ([PlaceOfBirthSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_PatSid_BirDt] on [CRS].[SPATIENT_PLACEOFBIRTH]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_PatSid_BirDt' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_PLACEOFBIRTH]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Sid_PatSid_BirDt] ON [CRS].[SPATIENT_PLACEOFBIRTH] ([PlaceOfBirthSID], [PatientSID], [BirthDateTime])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[SPATIENT_SPATIENTADDRESS]'
GO
IF OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTADDRESS]', 'U') IS NULL
CREATE TABLE [CRS].[SPATIENT_SPATIENTADDRESS]
(
[SPatientAddressSID] [int] NULL,
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[OrdinalNumber] [smallint] NULL,
[AddressType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NameOfContact] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RelationshipToPatient] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BadAddressIndicator] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress1] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress2] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StreetAddress3] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[City] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[County] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[State] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StateSID] [int] NULL,
[Zip] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Zip4] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Province] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PostalCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Country] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EmploymentStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Occupation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RetirementDateTime] [datetime2] NULL,
[RetirementVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RetirementDateTimeTransformSID] [bigint] NULL,
[AddressStartDateTime] [datetime2] NULL,
[AddressStartVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressStartDateTimeTransformSID] [bigint] NULL,
[AddressEndDateTime] [datetime2] NULL,
[AddressEndVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressEndDateTimeTransformSID] [bigint] NULL,
[AddressChangeStaffSID] [int] NULL,
[AddressChangeInstitutionSID] [int] NULL,
[AddressChangeDateTime] [datetime2] NULL,
[AddressChangeVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeDateTimeTransformSID] [bigint] NULL,
[AddressChangeSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISLocatorName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchStatusCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchScore] [int] NULL,
[GISMatchMethodCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMatchedAddress] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISAddressType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISStreetSide] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISPatientAddressLongitude] [float] NULL,
[GISPatientAddressLatitude] [float] NULL,
[GISAddressUpdatedDate] [date] NULL,
[GISFIPSCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISMarket] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISSubmarket] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISSector] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISURH] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GISCongressDistrict] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AddressChangeStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-Sid] on [CRS].[SPATIENT_SPATIENTADDRESS]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-Sid' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTADDRESS]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-Sid] ON [CRS].[SPATIENT_SPATIENTADDRESS] ([SPatientAddressSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_ETLID] on [CRS].[SPATIENT_SPATIENTADDRESS]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_ETLID' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTADDRESS]'))
CREATE UNIQUE NONCLUSTERED INDEX [NonClusteredIndex-Sid_ETLID] ON [CRS].[SPATIENT_SPATIENTADDRESS] ([SPatientAddressSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_PatSid_EtlId] on [CRS].[SPATIENT_SPATIENTADDRESS]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_PatSid_EtlId' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTADDRESS]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Sid_PatSid_EtlId] ON [CRS].[SPATIENT_SPATIENTADDRESS] ([SPatientAddressSID], [PatientSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[SPATIENT_SPATIENTDISABILITY]'
GO
IF OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTDISABILITY]', 'U') IS NULL
CREATE TABLE [CRS].[SPATIENT_SPATIENTDISABILITY]
(
[SPatientDisabilitySID] [int] NULL,
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[ClaimFolderInstitutionSID] [int] NULL,
[ClaimNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceConnectedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceConnectedPercent] [decimal] (18, 0) NULL,
[SCAwardDateTime] [datetime2] NULL,
[SCAwardVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SCAwardDateTimeTransformSID] [bigint] NULL,
[SCEffectiveDateTime] [datetime2] NULL,
[SCEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SCEffectiveDateTimeTransformSID] [bigint] NULL,
[MedalOfHonorFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SpinalCordInjuryCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SHADFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeExposureCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeRegistrationDateTime] [datetime2] NULL,
[AgentOrangeRegistrationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeRegistrationDateTimeTransformSID] [bigint] NULL,
[AgentOrangeLocation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeReportedDateTime] [datetime2] NULL,
[AgentOrangeReportedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeReportedDateTimeTransformSID] [bigint] NULL,
[AgentOrangeExamDateTime] [datetime2] NULL,
[AgentOrangeExamVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AgentOrangeExamDateTimeTransformSID] [bigint] NULL,
[AgentOrangeRegistrationNumber] [decimal] (18, 0) NULL,
[IonizingRadiationCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IonizingRadiationDateTime] [datetime2] NULL,
[IonizingRadiationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IonizingRadiationDateTimeTransformSID] [bigint] NULL,
[IonizingRadiationExposureCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SWAsiaCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SWAsiaRegistrationDateTime] [datetime2] NULL,
[SWAsiaRegistrationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SWAsiaRegistrationDateTimeTransformSID] [bigint] NULL,
[SWAsiaExamDateTime] [datetime2] NULL,
[SWAsiaExamVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SWAsiaExamDateTimeTransformSID] [bigint] NULL,
[POWStatusCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWLocation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWLocationSID] [int] NULL,
[POWStartDateTime] [datetime2] NULL,
[POWStartVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWStartDateTimeTransformSID] [bigint] NULL,
[POWEndDateTime] [datetime2] NULL,
[POWEndVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWEndDateTimeTransformSID] [bigint] NULL,
[POWVerifiedDateTime] [datetime2] NULL,
[POWVerifiedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWVerifiedDateTimeTransformSID] [bigint] NULL,
[CombatServiceFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatServiceLocation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatServiceStartDateTime] [datetime2] NULL,
[CombatServiceStartVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatServiceStartDateTimeTransformSID] [bigint] NULL,
[CombatServiceEndDateTime] [datetime2] NULL,
[CombatServiceEndVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatServiceEndDateTimeTransformSID] [bigint] NULL,
[CombatEligibilityEndDateTime] [datetime2] NULL,
[CombatEligibilityEndVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatEligibilityEndDateTimeTransformSID] [bigint] NULL,
[CombatEligibilityChangeDateTime] [datetime2] NULL,
[CombatEligibilityChangeVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CombatEligibilityChangeDateTimeTransformSID] [bigint] NULL,
[CampLejeuneFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CampLejeuneModifiedDateTime] [datetime2] NULL,
[CampLejeuneModifiedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CampLejeuneModifiedDateTimeTransformSID] [bigint] NULL,
[CampLejeuneModifiedSite] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CampLejeuneModifiedSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CampLejeuneDataLockedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnemployableFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReceivingVADisability] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VADisabilityAmount] [decimal] (18, 0) NULL,
[PTDisabilityFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PTEffectiveDateTime] [datetime2] NULL,
[PTEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PTEffectiveDateTimeTransformSID] [bigint] NULL,
[AidAndAttendanceCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AidAndAttendanceAmount] [decimal] (18, 0) NULL,
[HouseboundCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[HouseboundAmount] [decimal] (18, 0) NULL,
[ReceivingVAPension] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionAmount] [decimal] (18, 0) NULL,
[VAPensionEffectiveDateTime] [datetime2] NULL,
[VAPensionEffectiveVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionEffectiveDateTimeTransformSID] [bigint] NULL,
[VAPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionTerminationDateTime] [datetime2] NULL,
[VAPensionTerminationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionTerminationDateTimeTransformSID] [bigint] NULL,
[FirstTerminationPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SecondTerminationPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ThirdTerminationPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FourthTerminationPensionReason] [varchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionIndicatorLockedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAPensionEffectiveDateLockedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TotalVACheckAmount] [decimal] (18, 0) NULL,
[GovIssuedInsurance] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GovIssuedInsuranceAmount] [decimal] (18, 0) NULL,
[ReceivingMilitaryRetirement] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DischargeDueToDisabilityFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MilitaryDisabilityRetirementFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MilitaryDisabilityRetirementCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReceivingSocialSecurityBenefit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReceivingSocialSecurityInsurance] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SocialSecurityInsuranceAmount] [decimal] (18, 0) NULL,
[OtherRetirementTypeCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[OtherRetirementAmount] [decimal] (18, 0) NULL,
[OtherIncomeAmount] [decimal] (18, 0) NULL,
[MonetaryBenefitVerifiedDateTime] [datetime2] NULL,
[MonetaryBenefitVerifiedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MonetaryBenefitVerifiedDateTimeTransformSID] [bigint] NULL,
[ClaimFolderInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[POWLocationIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-Sid] on [CRS].[SPATIENT_SPATIENTDISABILITY]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-Sid' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTDISABILITY]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-Sid] ON [CRS].[SPATIENT_SPATIENTDISABILITY] ([SPatientDisabilitySID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_ETLID] on [CRS].[SPATIENT_SPATIENTDISABILITY]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_ETLID' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTDISABILITY]'))
CREATE UNIQUE NONCLUSTERED INDEX [NonClusteredIndex-Sid_ETLID] ON [CRS].[SPATIENT_SPATIENTDISABILITY] ([SPatientDisabilitySID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid_Flag_Percent] on [CRS].[SPATIENT_SPATIENTDISABILITY]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid_Flag_Percent' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTDISABILITY]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid_Flag_Percent] ON [CRS].[SPATIENT_SPATIENTDISABILITY] ([PatientSID], [ServiceConnectedFlag], [ServiceConnectedPercent])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[SPATIENT_SPATIENTPHONE]'
GO
IF OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTPHONE]', 'U') IS NULL
CREATE TABLE [CRS].[SPATIENT_SPATIENTPHONE]
(
[SPatientPhoneSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientSID] [int] NULL,
[Sta3n] [smallint] NULL,
[OrdinalNumber] [smallint] NULL,
[PatientContactType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NameOfContact] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RelationshipToPatient] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PhoneNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WorkPhoneNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EmailAddress] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ChangeDateTime] [datetime2] NULL,
[ChangeVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ChangeDateTimeTransformSID] [bigint] NULL,
[ChangeInstitutionSID] [int] NULL,
[ChangeSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ChangeInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-Sid] on [CRS].[SPATIENT_SPATIENTPHONE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-Sid' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTPHONE]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-Sid] ON [CRS].[SPATIENT_SPATIENTPHONE] ([SPatientPhoneSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Sid_ETLID] on [CRS].[SPATIENT_SPATIENTPHONE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Sid_ETLID' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTPHONE]'))
CREATE UNIQUE NONCLUSTERED INDEX [NonClusteredIndex-Sid_ETLID] ON [CRS].[SPATIENT_SPATIENTPHONE] ([SPatientPhoneSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid_OrdNum] on [CRS].[SPATIENT_SPATIENTPHONE]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid_OrdNum' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENTPHONE]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid_OrdNum] ON [CRS].[SPATIENT_SPATIENTPHONE] ([PatientSID], [OrdinalNumber])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[SPATIENT_SPATIENT]'
GO
IF OBJECT_ID(N'[CRS].[SPATIENT_SPATIENT]', 'U') IS NULL
CREATE TABLE [CRS].[SPATIENT_SPATIENT]
(
[PatientSID] [int] NULL,
[PatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[PatientName] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientLastName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientFirstName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TestPatientFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CDWPossibleTestPatientFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VeteranFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientTypeSID] [int] NULL,
[PatientICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ScrSSN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientSSN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PseudoSSNReason] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SSNVerificationStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[GovernmentEmployeeFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SensitiveFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Age] [numeric] (18, 0) NULL,
[BirthDateTime] [datetime2] NULL,
[BirthVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BirthDateTimeTransformSID] [bigint] NULL,
[DeceasedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathDateTime] [datetime2] NULL,
[DeathVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathDateTimeTransformSID] [bigint] NULL,
[DeathEnteredByStaffSID] [int] NULL,
[DeathNotificationSource] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathDocumentationType] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathModifiedDateTime] [datetime2] NULL,
[DeathModifiedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathModifiedDateTimeTransformSID] [bigint] NULL,
[DeathLastUpdatedByStaffSID] [int] NULL,
[Gender] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SelfIdentifiedGender] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Religion] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReligionSID] [int] NULL,
[MaritalStatus] [varchar] (25) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaritalStatusSID] [int] NULL,
[CollateralSponsorPatientSID] [int] NULL,
[CurrentEnrollmentSID] [bigint] NULL,
[MeansTestStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CurrentMeansTestStatusSID] [int] NULL,
[PeriodOfService] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PeriodOfServiceSID] [int] NULL,
[OperationDesertShieldRank] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ODSRankType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ODSRecalledCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ODSTreatmentDateTime] [datetime2] NULL,
[ODSTreatmentVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ODSTreatmentDateTimeTransformSID] [bigint] NULL,
[FederalAgencySID] [int] NULL,
[FilipinoVeteranCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ServiceConnectedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Eligibility] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityVACode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilitySID] [int] NULL,
[EligibilityStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityStatusDateTime] [datetime2] NULL,
[EligibilityStatusVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityStatusDateTimeTransformSID] [bigint] NULL,
[EligibilityVerificationSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityVerificationMethod] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityInterimDateTime] [datetime2] NULL,
[EligibilityInterimVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityInterimDateTimeTransformSID] [bigint] NULL,
[EligibilityEnteredStaffSID] [int] NULL,
[IneligibleReason] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleVAROReason] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleCity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleStateSID] [int] NULL,
[IneligibleDateTime] [datetime2] NULL,
[IneligibleVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleDateTimeTransformSID] [bigint] NULL,
[IneligibleSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingDateTime] [datetime2] NULL,
[PatientMissingVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingDateTimeTransformSID] [bigint] NULL,
[PatientMissingCity] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingStateSID] [int] NULL,
[FugitiveFelonFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFEnteredDateTime] [datetime2] NULL,
[FFFEnteredVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFEnteredDateTimeTransformSID] [bigint] NULL,
[FFFEnteredStaffSID] [int] NULL,
[FFFRemovedReason] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFRemovedDateTime] [datetime2] NULL,
[FFFRemovedVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFRemovedDateTimeTransformSID] [bigint] NULL,
[FFFRemovedStaffSID] [int] NULL,
[PatientEnteredByStaffSID] [int] NULL,
[PatientEnteredCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientEnteredRemark] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientEnteredDateTime] [datetime2] NULL,
[PatientEnteredVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientEnteredDateTimeTransformSID] [bigint] NULL,
[DuplicateRecordStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DestinationMergePatientSID] [int] NULL,
[PreferredInstitutionSID] [int] NULL,
[PreferredInstitutionSource] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EmergencyResponseIndicator] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InsuranceCoverageFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidEligibleFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidInquireDateTime] [datetime2] NULL,
[MedicaidInquireVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MedicaidInquireDateTimeTransformSID] [bigint] NULL,
[VeteranTransportationProgramFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CollateralSponsorPatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CurrentEnrollmentIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CurrentMeansTestStatusIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathEnteredByStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DeathLastUpdatedByStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DestinationMergePatientIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityEnteredStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilityIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FederalAgencyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFEnteredStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FFFRemovedStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IneligibleStateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaritalStatusIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientEnteredByStaffIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientMissingStateIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PatientTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PeriodOfServiceIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PreferredInstitutionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ReligionIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-PatSid] on [CRS].[SPATIENT_SPATIENT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-PatSid' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENT]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-PatSid] ON [CRS].[SPATIENT_SPATIENT] ([PatientSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID_ETLId] on [CRS].[SPATIENT_SPATIENT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID_ETLId' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENT]'))
CREATE UNIQUE NONCLUSTERED INDEX [NonClusteredIndex-SID_ETLId] ON [CRS].[SPATIENT_SPATIENT] ([PatientSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-PatSid_PatICN] on [CRS].[SPATIENT_SPATIENT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-PatSid_PatICN' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENT]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-PatSid_PatICN] ON [CRS].[SPATIENT_SPATIENT] ([PatientSID], [PatientICN])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-Name_ICN_SSN] on [CRS].[SPATIENT_SPATIENT]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-Name_ICN_SSN' AND object_id = OBJECT_ID(N'[CRS].[SPATIENT_SPATIENT]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-Name_ICN_SSN] ON [CRS].[SPATIENT_SPATIENT] ([PatientName], [PatientLastName], [PatientFirstName], [PatientICN], [PatientSSN])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_APPOINTMENTSTATUS]'
GO
IF OBJECT_ID(N'[CRS].[STD_APPOINTMENTSTATUS]', 'U') IS NULL
CREATE TABLE [CRS].[STD_APPOINTMENTSTATUS]
(
[AppointmentStatusSID] [smallint] NULL,
[AppointmentStatusIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[AppointmentStatus] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AppointmentStatusAbbreviation] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CheckInAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CancelAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NoShowAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CheckOutAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-SID] on [CRS].[STD_APPOINTMENTSTATUS]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-SID' AND object_id = OBJECT_ID(N'[CRS].[STD_APPOINTMENTSTATUS]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-SID] ON [CRS].[STD_APPOINTMENTSTATUS] ([AppointmentStatusSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID-ETLID] on [CRS].[STD_APPOINTMENTSTATUS]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID-ETLID' AND object_id = OBJECT_ID(N'[CRS].[STD_APPOINTMENTSTATUS]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-SID-ETLID] ON [CRS].[STD_APPOINTMENTSTATUS] ([AppointmentStatusSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_AppointmentType]'
GO
IF OBJECT_ID(N'[CRS].[STD_AppointmentType]', 'U') IS NULL
CREATE TABLE [CRS].[STD_AppointmentType]
(
[AppointmentTypeSID] [smallint] NULL,
[AppointmentTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[AppointmentType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IgnoreMeansTestBillingFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactiveFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AppointmentTypeSynonym] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DualEligibilityAllowedFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EligibilitySID] [int] NULL,
[EligibilityIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-SID] on [CRS].[STD_AppointmentType]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-SID' AND object_id = OBJECT_ID(N'[CRS].[STD_AppointmentType]'))
CREATE UNIQUE CLUSTERED INDEX [ClusteredIndex-SID] ON [CRS].[STD_AppointmentType] ([AppointmentTypeSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-SID-ETLID] on [CRS].[STD_AppointmentType]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-SID-ETLID' AND object_id = OBJECT_ID(N'[CRS].[STD_AppointmentType]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-SID-ETLID] ON [CRS].[STD_AppointmentType] ([AppointmentTypeSID], [ETLBatchID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_DIALYSISTYPE]'
GO
IF OBJECT_ID(N'[CRS].[STD_DIALYSISTYPE]', 'U') IS NULL
CREATE TABLE [CRS].[STD_DIALYSISTYPE]
(
[DialysisTypeSID] [int] NULL,
[DialysisTypeIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[DialysisTypeDescription] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DialysisTypeCode] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[UPDATED] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_ICD10Procedure_Code]'
GO
IF OBJECT_ID(N'[CRS].[STD_ICD10Procedure_Code]', 'U') IS NULL
CREATE TABLE [CRS].[STD_ICD10Procedure_Code]
(
[ICD10PROCEDURESID] [int] NOT NULL,
[ICDPROCEDUREIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[ICD10PROCEDURECODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD10ProcedureDescription] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDEXPANDEDFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDCODINGSYSTEMIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_ICD9Procedure_Code]'
GO
IF OBJECT_ID(N'[CRS].[STD_ICD9Procedure_Code]', 'U') IS NULL
CREATE TABLE [CRS].[STD_ICD9Procedure_Code]
(
[ICD9PROCEDURESID] [int] NOT NULL,
[ICD9PROCEDUREIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[ICD9PROCEDURECODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICD9ProcedureDescription] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDEXPANDEDFLAG] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICDCODINGSYSTEMIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_LOCALDRUG]'
GO
IF OBJECT_ID(N'[CRS].[STD_LOCALDRUG]', 'U') IS NULL
CREATE TABLE [CRS].[STD_LOCALDRUG]
(
[LocalDrugSID] [int] NULL,
[LocalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Sta3n] [smallint] NULL,
[LocalDrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NonFormularyFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalFormularyFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactivationDate] [date] NULL,
[InactivationVistaErrorDate] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[InactivationDateTransformSID] [bigint] NULL,
[LocalDrugMessage] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[QuantityDispensedMessage] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WarningLabel] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WarningMessageList] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[StandardSig] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DEAHandling] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxDosePerDay] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MaxDosePerDayNumeric] [decimal] (18, 0) NULL,
[OrderUnit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PricePerOrderUnit] [smallmoney] NULL,
[DispenseUnit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DispenseUnitsPerOrderUnit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DispenseUnitsPerOrderUnitNumeric] [decimal] (18, 0) NULL,
[PricePerDispenseUnit] [smallmoney] NULL,
[CMOPDispenseFlag] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CMOPID] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VAClassification] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[BestDrugClass] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalDrugSID] [int] NULL,
[NationalDrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugClassSID] [int] NULL,
[DrugClass] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ApplicationPackageUse] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NDC] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugNameWithoutDoseSID] [int] NULL,
[DrugNameWithoutDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DayOrDoseLimit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnitDoseScheduleType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnitDoseSchedule] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PharmacyOrderableItemSID] [int] NULL,
[PharmacyOrderableItem] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnitDoseMedicationRouteSID] [int] NULL,
[UnitDoseMedicationRoute] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CorrespondingInpatientLocalDrugSID] [int] NULL,
[CorrespondingInpatientLocalDrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CorrespondingOutpatientLocalDrugSID] [int] NULL,
[CorrespondingOutpatientLocalDrugNameWithDose] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NCPDPDispenseUnit] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NCPDPQuantityMultiplier] [decimal] (18, 0) NULL,
[DAW] [int] NULL,
[TopographySID] [int] NULL,
[SourceOfSupply] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AssociatedLabChemTestSID] [int] NULL,
[FederalStockNumber] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalDrug] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[AssociatedLabChemTestIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CorrespondingInpatientLocalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CorrespondingOutpatientLocalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugClassIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DrugNameWithoutDoseIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NationalDrugIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PharmacyOrderableItemIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TopographyIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UnitDoseMedicationRouteIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OpCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[VistaCreateDate] [datetime] NULL,
[VistaEditDate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_LOINC_Code]'
GO
IF OBJECT_ID(N'[CRS].[STD_LOINC_Code]', 'U') IS NULL
CREATE TABLE [CRS].[STD_LOINC_Code]
(
[LOINCSID] [int] NOT NULL,
[Sta3n] [smallint] NOT NULL,
[LOINCIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[LOINC] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Component] [varchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Property] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TimeAspect] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ScaleType] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MethodType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[NonPatientSpecimen] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Units] [varchar] (70) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ETLBatchID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex_STD_LOINC_Code_LOINCSID] on [CRS].[STD_LOINC_Code]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex_STD_LOINC_Code_LOINCSID' AND object_id = OBJECT_ID(N'[CRS].[STD_LOINC_Code]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex_STD_LOINC_Code_LOINCSID] ON [CRS].[STD_LOINC_Code] ([LOINCSID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[STD_StopCode]'
GO
IF OBJECT_ID(N'[CRS].[STD_StopCode]', 'U') IS NULL
CREATE TABLE [CRS].[STD_StopCode]
(
[STOPCODESID] [int] NOT NULL,
[STOPCODEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[STA3N] [smallint] NOT NULL,
[STOPCODE] [smallint] NULL,
[STOPCODENAME] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[INACTIVEDATE] [date] NULL,
[CONVERTTOSTOPCODEIEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COSTDISTRIBUTIONCENTER] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RESTRICTIONTYPE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[RESTRICTIONDATE] [date] NULL,
[ETLBATCHID] [int] NULL,
[OPCODE] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[VISTACREATEDATE] [datetime] NULL,
[VISTAEDITDATE] [datetime] NULL,
[CreatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex_DIM_StopCode_STOPCODESID] on [CRS].[STD_StopCode]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex_DIM_StopCode_STOPCODESID' AND object_id = OBJECT_ID(N'[CRS].[STD_StopCode]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex_DIM_StopCode_STOPCODESID] ON [CRS].[STD_StopCode] ([STOPCODESID])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[TRANSPLANTREGISTRY_TRACER]'
GO
IF OBJECT_ID(N'[CRS].[TRANSPLANTREGISTRY_TRACER]', 'U') IS NULL
CREATE TABLE [CRS].[TRANSPLANTREGISTRY_TRACER]
(
[TransplantID] [int] NULL,
[LocationID] [int] NULL,
[LocationName] [varchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FirstName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MiddleName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LastName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SSN] [varchar] (9) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DateOfBirth] [date] NULL,
[Gender] [varchar] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DateOfDeath] [date] NULL,
[PatientLastUpdated] [datetime] NULL,
[TransplantType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Organ] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TransplantDate] [date] NULL,
[KidneyDialysis] [bit] NULL,
[DialysisStartDate] [datetime] NULL,
[MELDScore] [int] NULL,
[LASScrore] [float] NULL,
[MCADType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TransplantCreatedDate] [datetime] NULL,
[TransplantLastUpdate] [datetime] NULL,
[LivingDonorProcedureType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DonorFirstName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DonorMiddleInitial] [varchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DonorLastName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DonorRelationType] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DonorLastUpdate] [datetime] NULL,
[StdRegistryId] [int] NULL,
[CreatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UpdatedBy] [varchar] (30) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[Created] [datetime] NULL,
[Updated] [datetime] NULL,
[ClosedDate] [datetime] NULL,
[ClosureReason] [varchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ProcessedFlag] [bit] NULL,
[PatientICN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
)
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [ClusteredIndex-FN-MN-LN-SSN-TT-Or] on [CRS].[TRANSPLANTREGISTRY_TRACER]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'ClusteredIndex-FN-MN-LN-SSN-TT-Or' AND object_id = OBJECT_ID(N'[CRS].[TRANSPLANTREGISTRY_TRACER]'))
CREATE CLUSTERED INDEX [ClusteredIndex-FN-MN-LN-SSN-TT-Or] ON [CRS].[TRANSPLANTREGISTRY_TRACER] ([FirstName], [MiddleName], [LastName], [SSN], [TransplantType], [Organ])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating index [NonClusteredIndex-ID-SSN-DOD] on [CRS].[TRANSPLANTREGISTRY_TRACER]'
GO
IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'NonClusteredIndex-ID-SSN-DOD' AND object_id = OBJECT_ID(N'[CRS].[TRANSPLANTREGISTRY_TRACER]'))
CREATE NONCLUSTERED INDEX [NonClusteredIndex-ID-SSN-DOD] ON [CRS].[TRANSPLANTREGISTRY_TRACER] ([TransplantID], [SSN], [DateOfDeath])
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
PRINT N'Creating [CRS].[GetAggregatesReport]'
GO
IF OBJECT_ID(N'[CRS].[GetAggregatesReport]', 'P') IS NULL
EXEC sp_executesql N'
CREATE PROCEDURE [CRS].[GetAggregatesReport]
	@CoreTypeOne varchar(100) = NULL,
	@CoreCodeOne varchar(100) = NULL,
	@CohortTypeOne varchar(100) = NULL,
	@CohortCodeOne varchar(100) = NULL,
	@CoreTypeTwo varchar(100) = NULL,
	@CoreCodeTwo varchar(100) = NULL,
	@CohortTypeTwo varchar(100) = NULL,
	@CohortCodeTwo varchar(100) = NULL
AS
BEGIN

	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @Select varchar(4000)
	DECLARE @Where varchar(4000)
	DECLARE @Joins varchar(4000)
	DECLARE @SelectAs varchar(4000)
	DECLARE @Fields varchar(4000)
	DECLARE @GroupBy varchar(4000)
	DECLARE @Field varchar(1000) = NULL

	SET @Where = '' WHERE (RF.STD_REGISTRY_ID = ''''12'''')''

	SET @Joins = '' LEFT JOIN CRS.PATIENT PT ON PT.PATIENTSID = SPT.PatientSID''
	SET @Joins = @Joins + '' LEFT JOIN CRS.REFERRAL RF ON RF.PATIENT_ID = PT.PATIENT_ID''

	SET @Fields = NULL

	SET @GroupBy = NULL
	SET @Field = NULL

	IF @CoreTypeOne IS NOT NULL
		BEGIN
		
			--Check for Core types starts here

			IF @CoreTypeOne = ''Allergy''
				BEGIN
					SET @Joins = @Joins + '' LEFT JOIN CRS.Allergy AL ON AL.PatientSID = SPT.PatientSID''
					SET @Field = '' AL.AllergyType''
				END

			IF @CoreTypeOne = ''Patient - Ethnicity''
				BEGIN
					SET @Joins = @Joins + '' LEFT JOIN CRS.PATIENT_ETHNICITY PE ON PE.PatientSID = SPT.PatientSID''
					SET @Field = '' PE.Ethnicity''
				END

			IF @CoreTypeOne = ''Patient - OEF/OIF''
				BEGIN
					SET @Joins = @Joins + '' LEFT JOIN CRS.OEFOIF_SERVICE OS ON OS.PatientSID = SPT.PatientSID''
					SET @Field = '' OS.LocationOfService''
				END

			--Check for Core types starts here

			IF @Fields IS NULL
				BEGIN
					SET @SelectAs = @Field + '' AS CoreTypeOne''
				END
			ELSE
				BEGIN
					SET @SelectAs = @SelectAs + '', '' + @Field + '' AS CoreTypeOne''
				END

			IF @Fields IS NULL
				BEGIN
					SET @Fields = @Field
				END
			ELSE
				BEGIN
					SET @Fields = @Fields + '', '' + @Field
				END

			IF @CoreCodeOne IS NULL
				BEGIN
					SET @Where = @Where + '' AND ('' + @Field + '' IS NOT NULL)''
				END
			ELSE
				BEGIN
					SET @Where = @Where + '' AND ('' + @Field + ''='''''' + @CoreCodeOne + '''''')''
				END
		END

	IF @CohortTypeOne IS NOT NULL
		BEGIN
		
			--Check for Cohort types starts here

			IF @CohortTypeOne = ''Gender''
				BEGIN
					SET @Field = ''SPT.Gender''
				END
			ELSE IF @CohortTypeOne = ''Ethnicity''
				BEGIN
					SET @Joins = @Joins + '' LEFT JOIN CRS.PATIENT_ETHNICITY PE ON PE.PatientSID = SPT.PatientSID''
					SET @Field = ''PE.Ethnicity''
				END
			

			--Check for Cohort types ends here

			IF @Fields IS NULL
				BEGIN
					SET @SelectAs = @Field + '' AS CohortTypeOne''
				END
			ELSE
				BEGIN
					SET @SelectAs = @SelectAs + '', '' + @Field + '' AS CohortTypeOne''
				END

			IF @Fields IS NULL
				BEGIN
					SET @Fields = @Field
				END
			ELSE
				BEGIN
					SET @Fields = @Fields + '','' + @Field
				END
			IF @CohortCodeOne IS NULL
				BEGIN
					SET @Where = @Where + '' AND ('' + @Field + '' IS NOT NULL)''
				END
			ELSE
				BEGIN

					SET @Where = @Where + '' AND ('' + @Field + ''='''''' + @CohortCodeOne + '''''')''
				END
		END

	IF @CoreTypeTwo IS NOT NULL
		BEGIN
		
			--Check for Additional Core types starts here

			IF @CoreTypeTwo = ''Allergy''
				BEGIN
					SET @Joins = @Joins + '' LEFT JOIN CRS.Allergy AL ON AL.PatientSID = SPT.PatientSID''
					SET @Field = '' AL.AllergyType''
				END

			IF @CoreTypeTwo = ''Patient - Ethnicity''
				BEGIN
					SET @Joins = @Joins + '' LEFT JOIN CRS.PATIENT_ETHNICITY PE ON PE.PatientSID = SPT.PatientSID''
					SET @Field = '' PE.Ethnicity''
				END

			IF @CoreTypeTwo = ''Patient - OEF/OIF''
				BEGIN
					SET @Joins = @Joins + '' LEFT JOIN CRS.OEFOIF_SERVICE OS ON OS.PatientSID = SPT.PatientSID''
					SET @Field = '' OS.LocationOfService''
				END

			--Check for Additional Core types starts here

			IF @Fields IS NULL
				BEGIN
					SET @SelectAs = @Field + '' AS CoreTypeTwo''
				END
			ELSE
				BEGIN
					SET @SelectAs = @SelectAs + '', '' + @Field + '' AS CoreTypeTwo''
				END

			IF @Fields IS NULL
				BEGIN
					SET @Fields = @Field
				END
			ELSE
				BEGIN
					SET @Fields = @Fields + '', '' + @Field
				END

			IF @CoreCodeTwo IS NULL
				BEGIN
					SET @Where = @Where + '' AND ('' + @Field + '' IS NOT NULL)''
				END
			ELSE
				BEGIN
					SET @Where = @Where + '' AND ('' + @Field + ''='''''' + @CoreCodeTwo + '''''')''
				END
		END

	IF @CohortTypeTwo IS NOT NULL
		BEGIN
		
			--Check for Additional Cohort types starts here

			IF @CohortTypeTwo = ''Gender''
				BEGIN
					SET @Field = ''SPT.Gender''
				END
			ELSE IF @CohortTypeTwo = ''Ethnicity''
				BEGIN
					SET @Joins = @Joins + '' LEFT JOIN CRS.PATIENT_ETHNICITY PE ON PE.PatientSID = SPT.PatientSID''
					SET @Field = ''PE.Ethnicity''
				END
			

			--Check for Additional Cohort types ends here

			IF @Fields IS NULL
				BEGIN
					SET @SelectAs = @Field + '' AS CohortTypeTwo''
				END
			ELSE
				BEGIN
					SET @SelectAs = @SelectAs + '', '' + @Field + '' AS CohortTypeTwo''
				END

			IF @Fields IS NULL
				BEGIN
					SET @Fields = @Field
				END
			ELSE
				BEGIN
					SET @Fields = @Fields + '','' + @Field
				END
			IF @CohortCodeTwo IS NULL
				BEGIN
					SET @Where = @Where + '' AND ('' + @Field + '' IS NOT NULL)''
				END
			ELSE
				BEGIN

					SET @Where = @Where + '' AND ('' + @Field + ''='''''' + @CohortCodeTwo + '''''')''
				END
		END

	IF @Fields IS NULL
		BEGIN
			SET @Fields = '' SPT.PATIENTFIRSTNAME, SPT.PATIENTLASTNAME ''
		END

	SET @GroupBy = '' GROUP BY '' + @Fields

	SET @Select = ''SELECT '' + @SelectAs + '', COUNT(DISTINCT SPT.PatientSID) AS Count FROM CRS.SPATIENT SPT''
	IF @Joins IS NOT NULL
		BEGIN
			SET @Select = @Select + @Joins
		END
	SET @Select = @Select + @Where
	SET @Select = @Select + @GroupBy

	EXEC (@Select)

END
'
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
COMMIT TRANSACTION
GO
IF @@ERROR <> 0 SET NOEXEC ON
GO
DECLARE @Success AS BIT
SET @Success = 1
SET NOEXEC OFF
IF (@Success = 1) PRINT 'The database update succeeded'
ELSE BEGIN
	IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION
	PRINT 'The database update failed'
END
GO
